package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{__integer, __string}
import scala.jdk.CollectionConverters._
final case class MultiplexSummary(
    arn: Option[__string] = None,
    availabilityZones: Option[Iterable[__string]] = None,
    id: Option[__string] = None,
    multiplexSettings: Option[
      zio.aws.medialive.model.MultiplexSettingsSummary
    ] = None,
    name: Option[__string] = None,
    pipelinesRunningCount: Option[__integer] = None,
    programCount: Option[__integer] = None,
    state: Option[zio.aws.medialive.model.MultiplexState] = None,
    tags: Option[Map[__string, __string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.MultiplexSummary = {
    import MultiplexSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.MultiplexSummary
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(multiplexSettings.map(value => value.buildAwsValue()))(
        _.multiplexSettings
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(pipelinesRunningCount.map(value => value: Integer))(
        _.pipelinesRunningCount
      )
      .optionallyWith(programCount.map(value => value: Integer))(_.programCount)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.MultiplexSummary.ReadOnly =
    zio.aws.medialive.model.MultiplexSummary.wrap(buildAwsValue())
}
object MultiplexSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.MultiplexSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.MultiplexSummary =
      zio.aws.medialive.model.MultiplexSummary(
        arn.map(value => value),
        availabilityZones.map(value => value),
        id.map(value => value),
        multiplexSettings.map(value => value.asEditable),
        name.map(value => value),
        pipelinesRunningCount.map(value => value),
        programCount.map(value => value),
        state.map(value => value),
        tags.map(value => value)
      )
    def arn: Option[__string]
    def availabilityZones: Option[List[__string]]
    def id: Option[__string]
    def multiplexSettings
        : Option[zio.aws.medialive.model.MultiplexSettingsSummary.ReadOnly]
    def name: Option[__string]
    def pipelinesRunningCount: Option[__integer]
    def programCount: Option[__integer]
    def state: Option[zio.aws.medialive.model.MultiplexState]
    def tags: Option[Map[__string, __string]]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getAvailabilityZones: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
    def getMultiplexSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.MultiplexSettingsSummary.ReadOnly
    ] = AwsError.unwrapOptionField("multiplexSettings", multiplexSettings)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getPipelinesRunningCount: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("pipelinesRunningCount", pipelinesRunningCount)
    def getProgramCount: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("programCount", programCount)
    def getState: ZIO[Any, AwsError, zio.aws.medialive.model.MultiplexState] =
      AwsError.unwrapOptionField("state", state)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.MultiplexSummary
  ) extends zio.aws.medialive.model.MultiplexSummary.ReadOnly {
    override val arn: Option[__string] =
      scala.Option(impl.arn()).map(value => value: __string)
    override val availabilityZones: Option[List[__string]] = scala
      .Option(impl.availabilityZones())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val id: Option[__string] =
      scala.Option(impl.id()).map(value => value: __string)
    override val multiplexSettings
        : Option[zio.aws.medialive.model.MultiplexSettingsSummary.ReadOnly] =
      scala
        .Option(impl.multiplexSettings())
        .map(value =>
          zio.aws.medialive.model.MultiplexSettingsSummary.wrap(value)
        )
    override val name: Option[__string] =
      scala.Option(impl.name()).map(value => value: __string)
    override val pipelinesRunningCount: Option[__integer] =
      scala.Option(impl.pipelinesRunningCount()).map(value => value: __integer)
    override val programCount: Option[__integer] =
      scala.Option(impl.programCount()).map(value => value: __integer)
    override val state: Option[zio.aws.medialive.model.MultiplexState] = scala
      .Option(impl.state())
      .map(value => zio.aws.medialive.model.MultiplexState.wrap(value))
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.MultiplexSummary
  ): zio.aws.medialive.model.MultiplexSummary.ReadOnly = new Wrapper(impl)
}
