package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__integerMin100000Max100000000
import scala.jdk.CollectionConverters._
final case class MultiplexVideoSettings(
    constantBitrate: Option[__integerMin100000Max100000000] = None,
    statmuxSettings: Option[
      zio.aws.medialive.model.MultiplexStatmuxVideoSettings
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.MultiplexVideoSettings = {
    import MultiplexVideoSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.MultiplexVideoSettings
      .builder()
      .optionallyWith(constantBitrate.map(value => value: Integer))(
        _.constantBitrate
      )
      .optionallyWith(statmuxSettings.map(value => value.buildAwsValue()))(
        _.statmuxSettings
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.MultiplexVideoSettings.ReadOnly =
    zio.aws.medialive.model.MultiplexVideoSettings.wrap(buildAwsValue())
}
object MultiplexVideoSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.MultiplexVideoSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.MultiplexVideoSettings =
      zio.aws.medialive.model.MultiplexVideoSettings(
        constantBitrate.map(value => value),
        statmuxSettings.map(value => value.asEditable)
      )
    def constantBitrate: Option[__integerMin100000Max100000000]
    def statmuxSettings
        : Option[zio.aws.medialive.model.MultiplexStatmuxVideoSettings.ReadOnly]
    def getConstantBitrate: ZIO[Any, AwsError, __integerMin100000Max100000000] =
      AwsError.unwrapOptionField("constantBitrate", constantBitrate)
    def getStatmuxSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.MultiplexStatmuxVideoSettings.ReadOnly
    ] = AwsError.unwrapOptionField("statmuxSettings", statmuxSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.MultiplexVideoSettings
  ) extends zio.aws.medialive.model.MultiplexVideoSettings.ReadOnly {
    override val constantBitrate: Option[__integerMin100000Max100000000] = scala
      .Option(impl.constantBitrate())
      .map(value => value: __integerMin100000Max100000000)
    override val statmuxSettings: Option[
      zio.aws.medialive.model.MultiplexStatmuxVideoSettings.ReadOnly
    ] = scala
      .Option(impl.statmuxSettings())
      .map(value =>
        zio.aws.medialive.model.MultiplexStatmuxVideoSettings.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.MultiplexVideoSettings
  ): zio.aws.medialive.model.MultiplexVideoSettings.ReadOnly = new Wrapper(impl)
}
