package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait NetworkInputServerValidation {
  def unwrap: software.amazon.awssdk.services.medialive.model.NetworkInputServerValidation
}
object NetworkInputServerValidation {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.NetworkInputServerValidation
  ): zio.aws.medialive.model.NetworkInputServerValidation = value match {
    case software.amazon.awssdk.services.medialive.model.NetworkInputServerValidation.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.NetworkInputServerValidation.CHECK_CRYPTOGRAPHY_AND_VALIDATE_NAME =>
      val r = CHECK_CRYPTOGRAPHY_AND_VALIDATE_NAME
      r
    case software.amazon.awssdk.services.medialive.model.NetworkInputServerValidation.CHECK_CRYPTOGRAPHY_ONLY =>
      val r = CHECK_CRYPTOGRAPHY_ONLY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.NetworkInputServerValidation {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.NetworkInputServerValidation =
      software.amazon.awssdk.services.medialive.model.NetworkInputServerValidation.UNKNOWN_TO_SDK_VERSION
  }
  case object CHECK_CRYPTOGRAPHY_AND_VALIDATE_NAME
      extends zio.aws.medialive.model.NetworkInputServerValidation {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.NetworkInputServerValidation =
      software.amazon.awssdk.services.medialive.model.NetworkInputServerValidation.CHECK_CRYPTOGRAPHY_AND_VALIDATE_NAME
  }
  case object CHECK_CRYPTOGRAPHY_ONLY
      extends zio.aws.medialive.model.NetworkInputServerValidation {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.NetworkInputServerValidation =
      software.amazon.awssdk.services.medialive.model.NetworkInputServerValidation.CHECK_CRYPTOGRAPHY_ONLY
  }
}
