package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NetworkInputSettings(
    hlsInputSettings: Option[zio.aws.medialive.model.HlsInputSettings] = None,
    serverValidation: Option[
      zio.aws.medialive.model.NetworkInputServerValidation
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.NetworkInputSettings = {
    import NetworkInputSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.NetworkInputSettings
      .builder()
      .optionallyWith(hlsInputSettings.map(value => value.buildAwsValue()))(
        _.hlsInputSettings
      )
      .optionallyWith(serverValidation.map(value => value.unwrap))(
        _.serverValidation
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.NetworkInputSettings.ReadOnly =
    zio.aws.medialive.model.NetworkInputSettings.wrap(buildAwsValue())
}
object NetworkInputSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.NetworkInputSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.NetworkInputSettings =
      zio.aws.medialive.model.NetworkInputSettings(
        hlsInputSettings.map(value => value.asEditable),
        serverValidation.map(value => value)
      )
    def hlsInputSettings
        : Option[zio.aws.medialive.model.HlsInputSettings.ReadOnly]
    def serverValidation
        : Option[zio.aws.medialive.model.NetworkInputServerValidation]
    def getHlsInputSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.HlsInputSettings.ReadOnly
    ] = AwsError.unwrapOptionField("hlsInputSettings", hlsInputSettings)
    def getServerValidation: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.NetworkInputServerValidation
    ] = AwsError.unwrapOptionField("serverValidation", serverValidation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.NetworkInputSettings
  ) extends zio.aws.medialive.model.NetworkInputSettings.ReadOnly {
    override val hlsInputSettings
        : Option[zio.aws.medialive.model.HlsInputSettings.ReadOnly] = scala
      .Option(impl.hlsInputSettings())
      .map(value => zio.aws.medialive.model.HlsInputSettings.wrap(value))
    override val serverValidation
        : Option[zio.aws.medialive.model.NetworkInputServerValidation] = scala
      .Option(impl.serverValidation())
      .map(value =>
        zio.aws.medialive.model.NetworkInputServerValidation.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.NetworkInputSettings
  ): zio.aws.medialive.model.NetworkInputSettings.ReadOnly = new Wrapper(impl)
}
