package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class NielsenConfiguration(
    distributorId: Option[__string] = None,
    nielsenPcmToId3Tagging: Option[
      zio.aws.medialive.model.NielsenPcmToId3TaggingState
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.NielsenConfiguration = {
    import NielsenConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.NielsenConfiguration
      .builder()
      .optionallyWith(distributorId.map(value => value: java.lang.String))(
        _.distributorId
      )
      .optionallyWith(nielsenPcmToId3Tagging.map(value => value.unwrap))(
        _.nielsenPcmToId3Tagging
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.NielsenConfiguration.ReadOnly =
    zio.aws.medialive.model.NielsenConfiguration.wrap(buildAwsValue())
}
object NielsenConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.NielsenConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.NielsenConfiguration =
      zio.aws.medialive.model.NielsenConfiguration(
        distributorId.map(value => value),
        nielsenPcmToId3Tagging.map(value => value)
      )
    def distributorId: Option[__string]
    def nielsenPcmToId3Tagging
        : Option[zio.aws.medialive.model.NielsenPcmToId3TaggingState]
    def getDistributorId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("distributorId", distributorId)
    def getNielsenPcmToId3Tagging: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.NielsenPcmToId3TaggingState
    ] = AwsError.unwrapOptionField(
      "nielsenPcmToId3Tagging",
      nielsenPcmToId3Tagging
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.NielsenConfiguration
  ) extends zio.aws.medialive.model.NielsenConfiguration.ReadOnly {
    override val distributorId: Option[__string] =
      scala.Option(impl.distributorId()).map(value => value: __string)
    override val nielsenPcmToId3Tagging
        : Option[zio.aws.medialive.model.NielsenPcmToId3TaggingState] = scala
      .Option(impl.nielsenPcmToId3Tagging())
      .map(value =>
        zio.aws.medialive.model.NielsenPcmToId3TaggingState.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.NielsenConfiguration
  ): zio.aws.medialive.model.NielsenConfiguration.ReadOnly = new Wrapper(impl)
}
