package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait NielsenPcmToId3TaggingState {
  def unwrap: software.amazon.awssdk.services.medialive.model.NielsenPcmToId3TaggingState
}
object NielsenPcmToId3TaggingState {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.NielsenPcmToId3TaggingState
  ): zio.aws.medialive.model.NielsenPcmToId3TaggingState = value match {
    case software.amazon.awssdk.services.medialive.model.NielsenPcmToId3TaggingState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.NielsenPcmToId3TaggingState.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.medialive.model.NielsenPcmToId3TaggingState.ENABLED =>
      val r = ENABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.NielsenPcmToId3TaggingState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.NielsenPcmToId3TaggingState =
      software.amazon.awssdk.services.medialive.model.NielsenPcmToId3TaggingState.UNKNOWN_TO_SDK_VERSION
  }
  case object DISABLED
      extends zio.aws.medialive.model.NielsenPcmToId3TaggingState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.NielsenPcmToId3TaggingState =
      software.amazon.awssdk.services.medialive.model.NielsenPcmToId3TaggingState.DISABLED
  }
  case object ENABLED
      extends zio.aws.medialive.model.NielsenPcmToId3TaggingState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.NielsenPcmToId3TaggingState =
      software.amazon.awssdk.services.medialive.model.NielsenPcmToId3TaggingState.ENABLED
  }
}
