package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NielsenWatermarksSettings(
    nielsenCbetSettings: Option[zio.aws.medialive.model.NielsenCBET] = None,
    nielsenDistributionType: Option[
      zio.aws.medialive.model.NielsenWatermarksDistributionTypes
    ] = None,
    nielsenNaesIiNwSettings: Option[zio.aws.medialive.model.NielsenNaesIiNw] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.NielsenWatermarksSettings = {
    import NielsenWatermarksSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.NielsenWatermarksSettings
      .builder()
      .optionallyWith(nielsenCbetSettings.map(value => value.buildAwsValue()))(
        _.nielsenCbetSettings
      )
      .optionallyWith(nielsenDistributionType.map(value => value.unwrap))(
        _.nielsenDistributionType
      )
      .optionallyWith(
        nielsenNaesIiNwSettings.map(value => value.buildAwsValue())
      )(_.nielsenNaesIiNwSettings)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.NielsenWatermarksSettings.ReadOnly =
    zio.aws.medialive.model.NielsenWatermarksSettings.wrap(buildAwsValue())
}
object NielsenWatermarksSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.NielsenWatermarksSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.NielsenWatermarksSettings =
      zio.aws.medialive.model.NielsenWatermarksSettings(
        nielsenCbetSettings.map(value => value.asEditable),
        nielsenDistributionType.map(value => value),
        nielsenNaesIiNwSettings.map(value => value.asEditable)
      )
    def nielsenCbetSettings
        : Option[zio.aws.medialive.model.NielsenCBET.ReadOnly]
    def nielsenDistributionType
        : Option[zio.aws.medialive.model.NielsenWatermarksDistributionTypes]
    def nielsenNaesIiNwSettings
        : Option[zio.aws.medialive.model.NielsenNaesIiNw.ReadOnly]
    def getNielsenCbetSettings
        : ZIO[Any, AwsError, zio.aws.medialive.model.NielsenCBET.ReadOnly] =
      AwsError.unwrapOptionField("nielsenCbetSettings", nielsenCbetSettings)
    def getNielsenDistributionType: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.NielsenWatermarksDistributionTypes
    ] = AwsError.unwrapOptionField(
      "nielsenDistributionType",
      nielsenDistributionType
    )
    def getNielsenNaesIiNwSettings
        : ZIO[Any, AwsError, zio.aws.medialive.model.NielsenNaesIiNw.ReadOnly] =
      AwsError.unwrapOptionField(
        "nielsenNaesIiNwSettings",
        nielsenNaesIiNwSettings
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.NielsenWatermarksSettings
  ) extends zio.aws.medialive.model.NielsenWatermarksSettings.ReadOnly {
    override val nielsenCbetSettings
        : Option[zio.aws.medialive.model.NielsenCBET.ReadOnly] = scala
      .Option(impl.nielsenCbetSettings())
      .map(value => zio.aws.medialive.model.NielsenCBET.wrap(value))
    override val nielsenDistributionType
        : Option[zio.aws.medialive.model.NielsenWatermarksDistributionTypes] =
      scala
        .Option(impl.nielsenDistributionType())
        .map(value =>
          zio.aws.medialive.model.NielsenWatermarksDistributionTypes.wrap(value)
        )
    override val nielsenNaesIiNwSettings
        : Option[zio.aws.medialive.model.NielsenNaesIiNw.ReadOnly] = scala
      .Option(impl.nielsenNaesIiNwSettings())
      .map(value => zio.aws.medialive.model.NielsenNaesIiNw.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.NielsenWatermarksSettings
  ): zio.aws.medialive.model.NielsenWatermarksSettings.ReadOnly = new Wrapper(
    impl
  )
}
