package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait OfferingType {
  def unwrap: software.amazon.awssdk.services.medialive.model.OfferingType
}
object OfferingType {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.OfferingType
  ): zio.aws.medialive.model.OfferingType = value match {
    case software.amazon.awssdk.services.medialive.model.OfferingType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.OfferingType.NO_UPFRONT =>
      val r = NO_UPFRONT
      r
  }
  case object unknownToSdkVersion extends zio.aws.medialive.model.OfferingType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.OfferingType =
      software.amazon.awssdk.services.medialive.model.OfferingType.UNKNOWN_TO_SDK_VERSION
  }
  case object NO_UPFRONT extends zio.aws.medialive.model.OfferingType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.OfferingType =
      software.amazon.awssdk.services.medialive.model.OfferingType.NO_UPFRONT
  }
}
