package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{__stringMin1Max255, __string}
import scala.jdk.CollectionConverters._
final case class Output(
    audioDescriptionNames: Option[Iterable[__string]] = None,
    captionDescriptionNames: Option[Iterable[__string]] = None,
    outputName: Option[__stringMin1Max255] = None,
    outputSettings: zio.aws.medialive.model.OutputSettings,
    videoDescriptionName: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.Output = {
    import Output.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.Output
      .builder()
      .optionallyWith(
        audioDescriptionNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.audioDescriptionNames)
      .optionallyWith(
        captionDescriptionNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.captionDescriptionNames)
      .optionallyWith(outputName.map(value => value: java.lang.String))(
        _.outputName
      )
      .outputSettings(outputSettings.buildAwsValue())
      .optionallyWith(
        videoDescriptionName.map(value => value: java.lang.String)
      )(_.videoDescriptionName)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.Output.ReadOnly =
    zio.aws.medialive.model.Output.wrap(buildAwsValue())
}
object Output {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.medialive.model.Output] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.Output =
      zio.aws.medialive.model.Output(
        audioDescriptionNames.map(value => value),
        captionDescriptionNames.map(value => value),
        outputName.map(value => value),
        outputSettings.asEditable,
        videoDescriptionName.map(value => value)
      )
    def audioDescriptionNames: Option[List[__string]]
    def captionDescriptionNames: Option[List[__string]]
    def outputName: Option[__stringMin1Max255]
    def outputSettings: zio.aws.medialive.model.OutputSettings.ReadOnly
    def videoDescriptionName: Option[__string]
    def getAudioDescriptionNames: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("audioDescriptionNames", audioDescriptionNames)
    def getCaptionDescriptionNames: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField(
        "captionDescriptionNames",
        captionDescriptionNames
      )
    def getOutputName: ZIO[Any, AwsError, __stringMin1Max255] =
      AwsError.unwrapOptionField("outputName", outputName)
    def getOutputSettings
        : ZIO[Any, Nothing, zio.aws.medialive.model.OutputSettings.ReadOnly] =
      ZIO.succeed(outputSettings)
    def getVideoDescriptionName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("videoDescriptionName", videoDescriptionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.Output
  ) extends zio.aws.medialive.model.Output.ReadOnly {
    override val audioDescriptionNames: Option[List[__string]] = scala
      .Option(impl.audioDescriptionNames())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val captionDescriptionNames: Option[List[__string]] = scala
      .Option(impl.captionDescriptionNames())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val outputName: Option[__stringMin1Max255] =
      scala.Option(impl.outputName()).map(value => value: __stringMin1Max255)
    override val outputSettings
        : zio.aws.medialive.model.OutputSettings.ReadOnly =
      zio.aws.medialive.model.OutputSettings.wrap(impl.outputSettings())
    override val videoDescriptionName: Option[__string] =
      scala.Option(impl.videoDescriptionName()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.Output
  ): zio.aws.medialive.model.Output.ReadOnly = new Wrapper(impl)
}
