package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class OutputDestination(
    id: Option[__string] = None,
    mediaPackageSettings: Option[
      Iterable[zio.aws.medialive.model.MediaPackageOutputDestinationSettings]
    ] = None,
    multiplexSettings: Option[
      zio.aws.medialive.model.MultiplexProgramChannelDestinationSettings
    ] = None,
    settings: Option[
      Iterable[zio.aws.medialive.model.OutputDestinationSettings]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.OutputDestination = {
    import OutputDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.OutputDestination
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(
        mediaPackageSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.mediaPackageSettings)
      .optionallyWith(multiplexSettings.map(value => value.buildAwsValue()))(
        _.multiplexSettings
      )
      .optionallyWith(
        settings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.settings)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.OutputDestination.ReadOnly =
    zio.aws.medialive.model.OutputDestination.wrap(buildAwsValue())
}
object OutputDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.OutputDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.OutputDestination =
      zio.aws.medialive.model.OutputDestination(
        id.map(value => value),
        mediaPackageSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        multiplexSettings.map(value => value.asEditable),
        settings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def id: Option[__string]
    def mediaPackageSettings: Option[List[
      zio.aws.medialive.model.MediaPackageOutputDestinationSettings.ReadOnly
    ]]
    def multiplexSettings: Option[
      zio.aws.medialive.model.MultiplexProgramChannelDestinationSettings.ReadOnly
    ]
    def settings: Option[
      List[zio.aws.medialive.model.OutputDestinationSettings.ReadOnly]
    ]
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
    def getMediaPackageSettings: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.MediaPackageOutputDestinationSettings.ReadOnly
    ]] =
      AwsError.unwrapOptionField("mediaPackageSettings", mediaPackageSettings)
    def getMultiplexSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.MultiplexProgramChannelDestinationSettings.ReadOnly
    ] = AwsError.unwrapOptionField("multiplexSettings", multiplexSettings)
    def getSettings: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.OutputDestinationSettings.ReadOnly
    ]] = AwsError.unwrapOptionField("settings", settings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.OutputDestination
  ) extends zio.aws.medialive.model.OutputDestination.ReadOnly {
    override val id: Option[__string] =
      scala.Option(impl.id()).map(value => value: __string)
    override val mediaPackageSettings: Option[List[
      zio.aws.medialive.model.MediaPackageOutputDestinationSettings.ReadOnly
    ]] = scala
      .Option(impl.mediaPackageSettings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.medialive.model.MediaPackageOutputDestinationSettings
            .wrap(item)
        }.toList
      )
    override val multiplexSettings: Option[
      zio.aws.medialive.model.MultiplexProgramChannelDestinationSettings.ReadOnly
    ] = scala
      .Option(impl.multiplexSettings())
      .map(value =>
        zio.aws.medialive.model.MultiplexProgramChannelDestinationSettings
          .wrap(value)
      )
    override val settings: Option[
      List[zio.aws.medialive.model.OutputDestinationSettings.ReadOnly]
    ] = scala
      .Option(impl.settings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.medialive.model.OutputDestinationSettings.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.OutputDestination
  ): zio.aws.medialive.model.OutputDestination.ReadOnly = new Wrapper(impl)
}
