package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__stringMax32
import scala.jdk.CollectionConverters._
final case class OutputGroup(
    name: Option[__stringMax32] = None,
    outputGroupSettings: zio.aws.medialive.model.OutputGroupSettings,
    outputs: Iterable[zio.aws.medialive.model.Output]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.OutputGroup = {
    import OutputGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.OutputGroup
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .outputGroupSettings(outputGroupSettings.buildAwsValue())
      .outputs(outputs.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.OutputGroup.ReadOnly =
    zio.aws.medialive.model.OutputGroup.wrap(buildAwsValue())
}
object OutputGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.OutputGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.OutputGroup =
      zio.aws.medialive.model.OutputGroup(
        name.map(value => value),
        outputGroupSettings.asEditable,
        outputs.map { item =>
          item.asEditable
        }
      )
    def name: Option[__stringMax32]
    def outputGroupSettings
        : zio.aws.medialive.model.OutputGroupSettings.ReadOnly
    def outputs: List[zio.aws.medialive.model.Output.ReadOnly]
    def getName: ZIO[Any, AwsError, __stringMax32] =
      AwsError.unwrapOptionField("name", name)
    def getOutputGroupSettings: ZIO[
      Any,
      Nothing,
      zio.aws.medialive.model.OutputGroupSettings.ReadOnly
    ] = ZIO.succeed(outputGroupSettings)
    def getOutputs
        : ZIO[Any, Nothing, List[zio.aws.medialive.model.Output.ReadOnly]] =
      ZIO.succeed(outputs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.OutputGroup
  ) extends zio.aws.medialive.model.OutputGroup.ReadOnly {
    override val name: Option[__stringMax32] =
      scala.Option(impl.name()).map(value => value: __stringMax32)
    override val outputGroupSettings
        : zio.aws.medialive.model.OutputGroupSettings.ReadOnly =
      zio.aws.medialive.model.OutputGroupSettings
        .wrap(impl.outputGroupSettings())
    override val outputs: List[zio.aws.medialive.model.Output.ReadOnly] = impl
      .outputs()
      .asScala
      .map { item =>
        zio.aws.medialive.model.Output.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.OutputGroup
  ): zio.aws.medialive.model.OutputGroup.ReadOnly = new Wrapper(impl)
}
