package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class OutputGroupSettings(
    archiveGroupSettings: Option[zio.aws.medialive.model.ArchiveGroupSettings] =
      None,
    frameCaptureGroupSettings: Option[
      zio.aws.medialive.model.FrameCaptureGroupSettings
    ] = None,
    hlsGroupSettings: Option[zio.aws.medialive.model.HlsGroupSettings] = None,
    mediaPackageGroupSettings: Option[
      zio.aws.medialive.model.MediaPackageGroupSettings
    ] = None,
    msSmoothGroupSettings: Option[
      zio.aws.medialive.model.MsSmoothGroupSettings
    ] = None,
    multiplexGroupSettings: Option[
      zio.aws.medialive.model.MultiplexGroupSettings
    ] = None,
    rtmpGroupSettings: Option[zio.aws.medialive.model.RtmpGroupSettings] = None,
    udpGroupSettings: Option[zio.aws.medialive.model.UdpGroupSettings] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.OutputGroupSettings = {
    import OutputGroupSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.OutputGroupSettings
      .builder()
      .optionallyWith(archiveGroupSettings.map(value => value.buildAwsValue()))(
        _.archiveGroupSettings
      )
      .optionallyWith(
        frameCaptureGroupSettings.map(value => value.buildAwsValue())
      )(_.frameCaptureGroupSettings)
      .optionallyWith(hlsGroupSettings.map(value => value.buildAwsValue()))(
        _.hlsGroupSettings
      )
      .optionallyWith(
        mediaPackageGroupSettings.map(value => value.buildAwsValue())
      )(_.mediaPackageGroupSettings)
      .optionallyWith(
        msSmoothGroupSettings.map(value => value.buildAwsValue())
      )(_.msSmoothGroupSettings)
      .optionallyWith(
        multiplexGroupSettings.map(value => value.buildAwsValue())
      )(_.multiplexGroupSettings)
      .optionallyWith(rtmpGroupSettings.map(value => value.buildAwsValue()))(
        _.rtmpGroupSettings
      )
      .optionallyWith(udpGroupSettings.map(value => value.buildAwsValue()))(
        _.udpGroupSettings
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.OutputGroupSettings.ReadOnly =
    zio.aws.medialive.model.OutputGroupSettings.wrap(buildAwsValue())
}
object OutputGroupSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.OutputGroupSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.OutputGroupSettings =
      zio.aws.medialive.model.OutputGroupSettings(
        archiveGroupSettings.map(value => value.asEditable),
        frameCaptureGroupSettings.map(value => value.asEditable),
        hlsGroupSettings.map(value => value.asEditable),
        mediaPackageGroupSettings.map(value => value.asEditable),
        msSmoothGroupSettings.map(value => value.asEditable),
        multiplexGroupSettings.map(value => value.asEditable),
        rtmpGroupSettings.map(value => value.asEditable),
        udpGroupSettings.map(value => value.asEditable)
      )
    def archiveGroupSettings
        : Option[zio.aws.medialive.model.ArchiveGroupSettings.ReadOnly]
    def frameCaptureGroupSettings
        : Option[zio.aws.medialive.model.FrameCaptureGroupSettings.ReadOnly]
    def hlsGroupSettings
        : Option[zio.aws.medialive.model.HlsGroupSettings.ReadOnly]
    def mediaPackageGroupSettings
        : Option[zio.aws.medialive.model.MediaPackageGroupSettings.ReadOnly]
    def msSmoothGroupSettings
        : Option[zio.aws.medialive.model.MsSmoothGroupSettings.ReadOnly]
    def multiplexGroupSettings
        : Option[zio.aws.medialive.model.MultiplexGroupSettings.ReadOnly]
    def rtmpGroupSettings
        : Option[zio.aws.medialive.model.RtmpGroupSettings.ReadOnly]
    def udpGroupSettings
        : Option[zio.aws.medialive.model.UdpGroupSettings.ReadOnly]
    def getArchiveGroupSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.ArchiveGroupSettings.ReadOnly
    ] = AwsError.unwrapOptionField("archiveGroupSettings", archiveGroupSettings)
    def getFrameCaptureGroupSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.FrameCaptureGroupSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "frameCaptureGroupSettings",
      frameCaptureGroupSettings
    )
    def getHlsGroupSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.HlsGroupSettings.ReadOnly
    ] = AwsError.unwrapOptionField("hlsGroupSettings", hlsGroupSettings)
    def getMediaPackageGroupSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.MediaPackageGroupSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "mediaPackageGroupSettings",
      mediaPackageGroupSettings
    )
    def getMsSmoothGroupSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.MsSmoothGroupSettings.ReadOnly
    ] =
      AwsError.unwrapOptionField("msSmoothGroupSettings", msSmoothGroupSettings)
    def getMultiplexGroupSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.MultiplexGroupSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "multiplexGroupSettings",
      multiplexGroupSettings
    )
    def getRtmpGroupSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.RtmpGroupSettings.ReadOnly
    ] = AwsError.unwrapOptionField("rtmpGroupSettings", rtmpGroupSettings)
    def getUdpGroupSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.UdpGroupSettings.ReadOnly
    ] = AwsError.unwrapOptionField("udpGroupSettings", udpGroupSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.OutputGroupSettings
  ) extends zio.aws.medialive.model.OutputGroupSettings.ReadOnly {
    override val archiveGroupSettings
        : Option[zio.aws.medialive.model.ArchiveGroupSettings.ReadOnly] = scala
      .Option(impl.archiveGroupSettings())
      .map(value => zio.aws.medialive.model.ArchiveGroupSettings.wrap(value))
    override val frameCaptureGroupSettings
        : Option[zio.aws.medialive.model.FrameCaptureGroupSettings.ReadOnly] =
      scala
        .Option(impl.frameCaptureGroupSettings())
        .map(value =>
          zio.aws.medialive.model.FrameCaptureGroupSettings.wrap(value)
        )
    override val hlsGroupSettings
        : Option[zio.aws.medialive.model.HlsGroupSettings.ReadOnly] = scala
      .Option(impl.hlsGroupSettings())
      .map(value => zio.aws.medialive.model.HlsGroupSettings.wrap(value))
    override val mediaPackageGroupSettings
        : Option[zio.aws.medialive.model.MediaPackageGroupSettings.ReadOnly] =
      scala
        .Option(impl.mediaPackageGroupSettings())
        .map(value =>
          zio.aws.medialive.model.MediaPackageGroupSettings.wrap(value)
        )
    override val msSmoothGroupSettings
        : Option[zio.aws.medialive.model.MsSmoothGroupSettings.ReadOnly] = scala
      .Option(impl.msSmoothGroupSettings())
      .map(value => zio.aws.medialive.model.MsSmoothGroupSettings.wrap(value))
    override val multiplexGroupSettings
        : Option[zio.aws.medialive.model.MultiplexGroupSettings.ReadOnly] =
      scala
        .Option(impl.multiplexGroupSettings())
        .map(value =>
          zio.aws.medialive.model.MultiplexGroupSettings.wrap(value)
        )
    override val rtmpGroupSettings
        : Option[zio.aws.medialive.model.RtmpGroupSettings.ReadOnly] = scala
      .Option(impl.rtmpGroupSettings())
      .map(value => zio.aws.medialive.model.RtmpGroupSettings.wrap(value))
    override val udpGroupSettings
        : Option[zio.aws.medialive.model.UdpGroupSettings.ReadOnly] = scala
      .Option(impl.udpGroupSettings())
      .map(value => zio.aws.medialive.model.UdpGroupSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.OutputGroupSettings
  ): zio.aws.medialive.model.OutputGroupSettings.ReadOnly = new Wrapper(impl)
}
