package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class OutputLocationRef(destinationRefId: Option[__string] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.OutputLocationRef = {
    import OutputLocationRef.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.OutputLocationRef
      .builder()
      .optionallyWith(destinationRefId.map(value => value: java.lang.String))(
        _.destinationRefId
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.OutputLocationRef.ReadOnly =
    zio.aws.medialive.model.OutputLocationRef.wrap(buildAwsValue())
}
object OutputLocationRef {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.OutputLocationRef
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.OutputLocationRef =
      zio.aws.medialive.model
        .OutputLocationRef(destinationRefId.map(value => value))
    def destinationRefId: Option[__string]
    def getDestinationRefId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("destinationRefId", destinationRefId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.OutputLocationRef
  ) extends zio.aws.medialive.model.OutputLocationRef.ReadOnly {
    override val destinationRefId: Option[__string] =
      scala.Option(impl.destinationRefId()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.OutputLocationRef
  ): zio.aws.medialive.model.OutputLocationRef.ReadOnly = new Wrapper(impl)
}
