package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class OutputSettings(
    archiveOutputSettings: Option[
      zio.aws.medialive.model.ArchiveOutputSettings
    ] = None,
    frameCaptureOutputSettings: Option[
      zio.aws.medialive.model.FrameCaptureOutputSettings
    ] = None,
    hlsOutputSettings: Option[zio.aws.medialive.model.HlsOutputSettings] = None,
    mediaPackageOutputSettings: Option[
      zio.aws.medialive.model.MediaPackageOutputSettings
    ] = None,
    msSmoothOutputSettings: Option[
      zio.aws.medialive.model.MsSmoothOutputSettings
    ] = None,
    multiplexOutputSettings: Option[
      zio.aws.medialive.model.MultiplexOutputSettings
    ] = None,
    rtmpOutputSettings: Option[zio.aws.medialive.model.RtmpOutputSettings] =
      None,
    udpOutputSettings: Option[zio.aws.medialive.model.UdpOutputSettings] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.OutputSettings = {
    import OutputSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.OutputSettings
      .builder()
      .optionallyWith(
        archiveOutputSettings.map(value => value.buildAwsValue())
      )(_.archiveOutputSettings)
      .optionallyWith(
        frameCaptureOutputSettings.map(value => value.buildAwsValue())
      )(_.frameCaptureOutputSettings)
      .optionallyWith(hlsOutputSettings.map(value => value.buildAwsValue()))(
        _.hlsOutputSettings
      )
      .optionallyWith(
        mediaPackageOutputSettings.map(value => value.buildAwsValue())
      )(_.mediaPackageOutputSettings)
      .optionallyWith(
        msSmoothOutputSettings.map(value => value.buildAwsValue())
      )(_.msSmoothOutputSettings)
      .optionallyWith(
        multiplexOutputSettings.map(value => value.buildAwsValue())
      )(_.multiplexOutputSettings)
      .optionallyWith(rtmpOutputSettings.map(value => value.buildAwsValue()))(
        _.rtmpOutputSettings
      )
      .optionallyWith(udpOutputSettings.map(value => value.buildAwsValue()))(
        _.udpOutputSettings
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.OutputSettings.ReadOnly =
    zio.aws.medialive.model.OutputSettings.wrap(buildAwsValue())
}
object OutputSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.OutputSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.OutputSettings =
      zio.aws.medialive.model.OutputSettings(
        archiveOutputSettings.map(value => value.asEditable),
        frameCaptureOutputSettings.map(value => value.asEditable),
        hlsOutputSettings.map(value => value.asEditable),
        mediaPackageOutputSettings.map(value => value.asEditable),
        msSmoothOutputSettings.map(value => value.asEditable),
        multiplexOutputSettings.map(value => value.asEditable),
        rtmpOutputSettings.map(value => value.asEditable),
        udpOutputSettings.map(value => value.asEditable)
      )
    def archiveOutputSettings
        : Option[zio.aws.medialive.model.ArchiveOutputSettings.ReadOnly]
    def frameCaptureOutputSettings
        : Option[zio.aws.medialive.model.FrameCaptureOutputSettings.ReadOnly]
    def hlsOutputSettings
        : Option[zio.aws.medialive.model.HlsOutputSettings.ReadOnly]
    def mediaPackageOutputSettings
        : Option[zio.aws.medialive.model.MediaPackageOutputSettings.ReadOnly]
    def msSmoothOutputSettings
        : Option[zio.aws.medialive.model.MsSmoothOutputSettings.ReadOnly]
    def multiplexOutputSettings
        : Option[zio.aws.medialive.model.MultiplexOutputSettings.ReadOnly]
    def rtmpOutputSettings
        : Option[zio.aws.medialive.model.RtmpOutputSettings.ReadOnly]
    def udpOutputSettings
        : Option[zio.aws.medialive.model.UdpOutputSettings.ReadOnly]
    def getArchiveOutputSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.ArchiveOutputSettings.ReadOnly
    ] =
      AwsError.unwrapOptionField("archiveOutputSettings", archiveOutputSettings)
    def getFrameCaptureOutputSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.FrameCaptureOutputSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "frameCaptureOutputSettings",
      frameCaptureOutputSettings
    )
    def getHlsOutputSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.HlsOutputSettings.ReadOnly
    ] = AwsError.unwrapOptionField("hlsOutputSettings", hlsOutputSettings)
    def getMediaPackageOutputSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.MediaPackageOutputSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "mediaPackageOutputSettings",
      mediaPackageOutputSettings
    )
    def getMsSmoothOutputSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.MsSmoothOutputSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "msSmoothOutputSettings",
      msSmoothOutputSettings
    )
    def getMultiplexOutputSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.MultiplexOutputSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "multiplexOutputSettings",
      multiplexOutputSettings
    )
    def getRtmpOutputSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.RtmpOutputSettings.ReadOnly
    ] = AwsError.unwrapOptionField("rtmpOutputSettings", rtmpOutputSettings)
    def getUdpOutputSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.UdpOutputSettings.ReadOnly
    ] = AwsError.unwrapOptionField("udpOutputSettings", udpOutputSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.OutputSettings
  ) extends zio.aws.medialive.model.OutputSettings.ReadOnly {
    override val archiveOutputSettings
        : Option[zio.aws.medialive.model.ArchiveOutputSettings.ReadOnly] = scala
      .Option(impl.archiveOutputSettings())
      .map(value => zio.aws.medialive.model.ArchiveOutputSettings.wrap(value))
    override val frameCaptureOutputSettings
        : Option[zio.aws.medialive.model.FrameCaptureOutputSettings.ReadOnly] =
      scala
        .Option(impl.frameCaptureOutputSettings())
        .map(value =>
          zio.aws.medialive.model.FrameCaptureOutputSettings.wrap(value)
        )
    override val hlsOutputSettings
        : Option[zio.aws.medialive.model.HlsOutputSettings.ReadOnly] = scala
      .Option(impl.hlsOutputSettings())
      .map(value => zio.aws.medialive.model.HlsOutputSettings.wrap(value))
    override val mediaPackageOutputSettings
        : Option[zio.aws.medialive.model.MediaPackageOutputSettings.ReadOnly] =
      scala
        .Option(impl.mediaPackageOutputSettings())
        .map(value =>
          zio.aws.medialive.model.MediaPackageOutputSettings.wrap(value)
        )
    override val msSmoothOutputSettings
        : Option[zio.aws.medialive.model.MsSmoothOutputSettings.ReadOnly] =
      scala
        .Option(impl.msSmoothOutputSettings())
        .map(value =>
          zio.aws.medialive.model.MsSmoothOutputSettings.wrap(value)
        )
    override val multiplexOutputSettings
        : Option[zio.aws.medialive.model.MultiplexOutputSettings.ReadOnly] =
      scala
        .Option(impl.multiplexOutputSettings())
        .map(value =>
          zio.aws.medialive.model.MultiplexOutputSettings.wrap(value)
        )
    override val rtmpOutputSettings
        : Option[zio.aws.medialive.model.RtmpOutputSettings.ReadOnly] = scala
      .Option(impl.rtmpOutputSettings())
      .map(value => zio.aws.medialive.model.RtmpOutputSettings.wrap(value))
    override val udpOutputSettings
        : Option[zio.aws.medialive.model.UdpOutputSettings.ReadOnly] = scala
      .Option(impl.udpOutputSettings())
      .map(value => zio.aws.medialive.model.UdpOutputSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.OutputSettings
  ): zio.aws.medialive.model.OutputSettings.ReadOnly = new Wrapper(impl)
}
