package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PauseStateScheduleActionSettings(
    pipelines: Option[
      Iterable[zio.aws.medialive.model.PipelinePauseStateSettings]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.PauseStateScheduleActionSettings = {
    import PauseStateScheduleActionSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.PauseStateScheduleActionSettings
      .builder()
      .optionallyWith(
        pipelines.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pipelines)
      .build()
  }
  def asReadOnly
      : zio.aws.medialive.model.PauseStateScheduleActionSettings.ReadOnly =
    zio.aws.medialive.model.PauseStateScheduleActionSettings
      .wrap(buildAwsValue())
}
object PauseStateScheduleActionSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.PauseStateScheduleActionSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.PauseStateScheduleActionSettings =
      zio.aws.medialive.model.PauseStateScheduleActionSettings(
        pipelines.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def pipelines: Option[
      List[zio.aws.medialive.model.PipelinePauseStateSettings.ReadOnly]
    ]
    def getPipelines: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.PipelinePauseStateSettings.ReadOnly
    ]] = AwsError.unwrapOptionField("pipelines", pipelines)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.PauseStateScheduleActionSettings
  ) extends zio.aws.medialive.model.PauseStateScheduleActionSettings.ReadOnly {
    override val pipelines: Option[
      List[zio.aws.medialive.model.PipelinePauseStateSettings.ReadOnly]
    ] = scala
      .Option(impl.pipelines())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.medialive.model.PipelinePauseStateSettings.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.PauseStateScheduleActionSettings
  ): zio.aws.medialive.model.PauseStateScheduleActionSettings.ReadOnly =
    new Wrapper(impl)
}
