package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class PipelineDetail(
    activeInputAttachmentName: Option[__string] = None,
    activeInputSwitchActionName: Option[__string] = None,
    activeMotionGraphicsActionName: Option[__string] = None,
    activeMotionGraphicsUri: Option[__string] = None,
    pipelineId: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.PipelineDetail = {
    import PipelineDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.PipelineDetail
      .builder()
      .optionallyWith(
        activeInputAttachmentName.map(value => value: java.lang.String)
      )(_.activeInputAttachmentName)
      .optionallyWith(
        activeInputSwitchActionName.map(value => value: java.lang.String)
      )(_.activeInputSwitchActionName)
      .optionallyWith(
        activeMotionGraphicsActionName.map(value => value: java.lang.String)
      )(_.activeMotionGraphicsActionName)
      .optionallyWith(
        activeMotionGraphicsUri.map(value => value: java.lang.String)
      )(_.activeMotionGraphicsUri)
      .optionallyWith(pipelineId.map(value => value: java.lang.String))(
        _.pipelineId
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.PipelineDetail.ReadOnly =
    zio.aws.medialive.model.PipelineDetail.wrap(buildAwsValue())
}
object PipelineDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.PipelineDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.PipelineDetail =
      zio.aws.medialive.model.PipelineDetail(
        activeInputAttachmentName.map(value => value),
        activeInputSwitchActionName.map(value => value),
        activeMotionGraphicsActionName.map(value => value),
        activeMotionGraphicsUri.map(value => value),
        pipelineId.map(value => value)
      )
    def activeInputAttachmentName: Option[__string]
    def activeInputSwitchActionName: Option[__string]
    def activeMotionGraphicsActionName: Option[__string]
    def activeMotionGraphicsUri: Option[__string]
    def pipelineId: Option[__string]
    def getActiveInputAttachmentName: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("activeInputAttachmentName", activeInputAttachmentName)
    def getActiveInputSwitchActionName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField(
        "activeInputSwitchActionName",
        activeInputSwitchActionName
      )
    def getActiveMotionGraphicsActionName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField(
        "activeMotionGraphicsActionName",
        activeMotionGraphicsActionName
      )
    def getActiveMotionGraphicsUri: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("activeMotionGraphicsUri", activeMotionGraphicsUri)
    def getPipelineId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("pipelineId", pipelineId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.PipelineDetail
  ) extends zio.aws.medialive.model.PipelineDetail.ReadOnly {
    override val activeInputAttachmentName: Option[__string] = scala
      .Option(impl.activeInputAttachmentName())
      .map(value => value: __string)
    override val activeInputSwitchActionName: Option[__string] = scala
      .Option(impl.activeInputSwitchActionName())
      .map(value => value: __string)
    override val activeMotionGraphicsActionName: Option[__string] = scala
      .Option(impl.activeMotionGraphicsActionName())
      .map(value => value: __string)
    override val activeMotionGraphicsUri: Option[__string] =
      scala.Option(impl.activeMotionGraphicsUri()).map(value => value: __string)
    override val pipelineId: Option[__string] =
      scala.Option(impl.pipelineId()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.PipelineDetail
  ): zio.aws.medialive.model.PipelineDetail.ReadOnly = new Wrapper(impl)
}
