package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait PipelineId {
  def unwrap: software.amazon.awssdk.services.medialive.model.PipelineId
}
object PipelineId {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.PipelineId
  ): zio.aws.medialive.model.PipelineId = value match {
    case software.amazon.awssdk.services.medialive.model.PipelineId.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.PipelineId.PIPELINE_0 =>
      val r = PIPELINE_0
      r
    case software.amazon.awssdk.services.medialive.model.PipelineId.PIPELINE_1 =>
      val r = PIPELINE_1
      r
  }
  case object unknownToSdkVersion extends zio.aws.medialive.model.PipelineId {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.PipelineId =
      software.amazon.awssdk.services.medialive.model.PipelineId.UNKNOWN_TO_SDK_VERSION
  }
  case object PIPELINE_0 extends zio.aws.medialive.model.PipelineId {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.PipelineId =
      software.amazon.awssdk.services.medialive.model.PipelineId.PIPELINE_0
  }
  case object PIPELINE_1 extends zio.aws.medialive.model.PipelineId {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.PipelineId =
      software.amazon.awssdk.services.medialive.model.PipelineId.PIPELINE_1
  }
}
