package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PipelinePauseStateSettings(
    pipelineId: zio.aws.medialive.model.PipelineId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.PipelinePauseStateSettings = {
    import PipelinePauseStateSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.PipelinePauseStateSettings
      .builder()
      .pipelineId(pipelineId.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.PipelinePauseStateSettings.ReadOnly =
    zio.aws.medialive.model.PipelinePauseStateSettings.wrap(buildAwsValue())
}
object PipelinePauseStateSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.PipelinePauseStateSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.PipelinePauseStateSettings =
      zio.aws.medialive.model.PipelinePauseStateSettings(pipelineId)
    def pipelineId: zio.aws.medialive.model.PipelineId
    def getPipelineId: ZIO[Any, Nothing, zio.aws.medialive.model.PipelineId] =
      ZIO.succeed(pipelineId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.PipelinePauseStateSettings
  ) extends zio.aws.medialive.model.PipelinePauseStateSettings.ReadOnly {
    override val pipelineId: zio.aws.medialive.model.PipelineId =
      zio.aws.medialive.model.PipelineId.wrap(impl.pipelineId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.PipelinePauseStateSettings
  ): zio.aws.medialive.model.PipelinePauseStateSettings.ReadOnly = new Wrapper(
    impl
  )
}
