package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait PreferredChannelPipeline {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.PreferredChannelPipeline
}
object PreferredChannelPipeline {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.PreferredChannelPipeline
  ): zio.aws.medialive.model.PreferredChannelPipeline = value match {
    case software.amazon.awssdk.services.medialive.model.PreferredChannelPipeline.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.PreferredChannelPipeline.CURRENTLY_ACTIVE =>
      val r = CURRENTLY_ACTIVE
      r
    case software.amazon.awssdk.services.medialive.model.PreferredChannelPipeline.PIPELINE_0 =>
      val r = PIPELINE_0
      r
    case software.amazon.awssdk.services.medialive.model.PreferredChannelPipeline.PIPELINE_1 =>
      val r = PIPELINE_1
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.PreferredChannelPipeline {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.PreferredChannelPipeline =
      software.amazon.awssdk.services.medialive.model.PreferredChannelPipeline.UNKNOWN_TO_SDK_VERSION
  }
  case object CURRENTLY_ACTIVE
      extends zio.aws.medialive.model.PreferredChannelPipeline {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.PreferredChannelPipeline =
      software.amazon.awssdk.services.medialive.model.PreferredChannelPipeline.CURRENTLY_ACTIVE
  }
  case object PIPELINE_0
      extends zio.aws.medialive.model.PreferredChannelPipeline {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.PreferredChannelPipeline =
      software.amazon.awssdk.services.medialive.model.PreferredChannelPipeline.PIPELINE_0
  }
  case object PIPELINE_1
      extends zio.aws.medialive.model.PreferredChannelPipeline {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.PreferredChannelPipeline =
      software.amazon.awssdk.services.medialive.model.PreferredChannelPipeline.PIPELINE_1
  }
}
