package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{__string, __integerMin1}
import scala.jdk.CollectionConverters._
final case class PurchaseOfferingRequest(
    count: __integerMin1,
    name: Option[__string] = None,
    offeringId: __string,
    requestId: Option[__string] = None,
    start: Option[__string] = None,
    tags: Option[Map[__string, __string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.PurchaseOfferingRequest = {
    import PurchaseOfferingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.PurchaseOfferingRequest
      .builder()
      .count(count: Integer)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .offeringId(offeringId: java.lang.String)
      .optionallyWith(requestId.map(value => value: java.lang.String))(
        _.requestId
      )
      .optionallyWith(start.map(value => value: java.lang.String))(_.start)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.PurchaseOfferingRequest.ReadOnly =
    zio.aws.medialive.model.PurchaseOfferingRequest.wrap(buildAwsValue())
}
object PurchaseOfferingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.PurchaseOfferingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.PurchaseOfferingRequest =
      zio.aws.medialive.model.PurchaseOfferingRequest(
        count,
        name.map(value => value),
        offeringId,
        requestId.map(value => value),
        start.map(value => value),
        tags.map(value => value)
      )
    def count: __integerMin1
    def name: Option[__string]
    def offeringId: __string
    def requestId: Option[__string]
    def start: Option[__string]
    def tags: Option[Map[__string, __string]]
    def getCount: ZIO[Any, Nothing, __integerMin1] = ZIO.succeed(count)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getOfferingId: ZIO[Any, Nothing, __string] = ZIO.succeed(offeringId)
    def getRequestId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getStart: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("start", start)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.PurchaseOfferingRequest
  ) extends zio.aws.medialive.model.PurchaseOfferingRequest.ReadOnly {
    override val count: __integerMin1 = impl.count(): __integerMin1
    override val name: Option[__string] =
      scala.Option(impl.name()).map(value => value: __string)
    override val offeringId: __string = impl.offeringId(): __string
    override val requestId: Option[__string] =
      scala.Option(impl.requestId()).map(value => value: __string)
    override val start: Option[__string] =
      scala.Option(impl.start()).map(value => value: __string)
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.PurchaseOfferingRequest
  ): zio.aws.medialive.model.PurchaseOfferingRequest.ReadOnly = new Wrapper(
    impl
  )
}
