package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PurchaseOfferingResponse(
    reservation: Option[zio.aws.medialive.model.Reservation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.PurchaseOfferingResponse = {
    import PurchaseOfferingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.PurchaseOfferingResponse
      .builder()
      .optionallyWith(reservation.map(value => value.buildAwsValue()))(
        _.reservation
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.PurchaseOfferingResponse.ReadOnly =
    zio.aws.medialive.model.PurchaseOfferingResponse.wrap(buildAwsValue())
}
object PurchaseOfferingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.PurchaseOfferingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.PurchaseOfferingResponse =
      zio.aws.medialive.model
        .PurchaseOfferingResponse(reservation.map(value => value.asEditable))
    def reservation: Option[zio.aws.medialive.model.Reservation.ReadOnly]
    def getReservation
        : ZIO[Any, AwsError, zio.aws.medialive.model.Reservation.ReadOnly] =
      AwsError.unwrapOptionField("reservation", reservation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.PurchaseOfferingResponse
  ) extends zio.aws.medialive.model.PurchaseOfferingResponse.ReadOnly {
    override val reservation
        : Option[zio.aws.medialive.model.Reservation.ReadOnly] = scala
      .Option(impl.reservation())
      .map(value => zio.aws.medialive.model.Reservation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.PurchaseOfferingResponse
  ): zio.aws.medialive.model.PurchaseOfferingResponse.ReadOnly = new Wrapper(
    impl
  )
}
