package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{
  __integerMin1Max8,
  __integerMin1Max16
}
import scala.jdk.CollectionConverters._
final case class RemixSettings(
    channelMappings: Iterable[zio.aws.medialive.model.AudioChannelMapping],
    channelsIn: Option[__integerMin1Max16] = None,
    channelsOut: Option[__integerMin1Max8] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.RemixSettings = {
    import RemixSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.RemixSettings
      .builder()
      .channelMappings(channelMappings.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(channelsIn.map(value => value: Integer))(_.channelsIn)
      .optionallyWith(channelsOut.map(value => value: Integer))(_.channelsOut)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.RemixSettings.ReadOnly =
    zio.aws.medialive.model.RemixSettings.wrap(buildAwsValue())
}
object RemixSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.RemixSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.RemixSettings =
      zio.aws.medialive.model.RemixSettings(
        channelMappings.map { item =>
          item.asEditable
        },
        channelsIn.map(value => value),
        channelsOut.map(value => value)
      )
    def channelMappings
        : List[zio.aws.medialive.model.AudioChannelMapping.ReadOnly]
    def channelsIn: Option[__integerMin1Max16]
    def channelsOut: Option[__integerMin1Max8]
    def getChannelMappings: ZIO[Any, Nothing, List[
      zio.aws.medialive.model.AudioChannelMapping.ReadOnly
    ]] = ZIO.succeed(channelMappings)
    def getChannelsIn: ZIO[Any, AwsError, __integerMin1Max16] =
      AwsError.unwrapOptionField("channelsIn", channelsIn)
    def getChannelsOut: ZIO[Any, AwsError, __integerMin1Max8] =
      AwsError.unwrapOptionField("channelsOut", channelsOut)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.RemixSettings
  ) extends zio.aws.medialive.model.RemixSettings.ReadOnly {
    override val channelMappings
        : List[zio.aws.medialive.model.AudioChannelMapping.ReadOnly] = impl
      .channelMappings()
      .asScala
      .map { item =>
        zio.aws.medialive.model.AudioChannelMapping.wrap(item)
      }
      .toList
    override val channelsIn: Option[__integerMin1Max16] =
      scala.Option(impl.channelsIn()).map(value => value: __integerMin1Max16)
    override val channelsOut: Option[__integerMin1Max8] =
      scala.Option(impl.channelsOut()).map(value => value: __integerMin1Max8)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.RemixSettings
  ): zio.aws.medialive.model.RemixSettings.ReadOnly = new Wrapper(impl)
}
