package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait ReservationCodec {
  def unwrap: software.amazon.awssdk.services.medialive.model.ReservationCodec
}
object ReservationCodec {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.ReservationCodec
  ): zio.aws.medialive.model.ReservationCodec = value match {
    case software.amazon.awssdk.services.medialive.model.ReservationCodec.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.ReservationCodec.MPEG2 =>
      val r = MPEG2
      r
    case software.amazon.awssdk.services.medialive.model.ReservationCodec.AVC =>
      val r = AVC
      r
    case software.amazon.awssdk.services.medialive.model.ReservationCodec.HEVC =>
      val r = HEVC
      r
    case software.amazon.awssdk.services.medialive.model.ReservationCodec.AUDIO =>
      val r = AUDIO
      r
    case software.amazon.awssdk.services.medialive.model.ReservationCodec.LINK =>
      val r = LINK
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.ReservationCodec {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ReservationCodec =
      software.amazon.awssdk.services.medialive.model.ReservationCodec.UNKNOWN_TO_SDK_VERSION
  }
  case object MPEG2 extends zio.aws.medialive.model.ReservationCodec {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ReservationCodec =
      software.amazon.awssdk.services.medialive.model.ReservationCodec.MPEG2
  }
  case object AVC extends zio.aws.medialive.model.ReservationCodec {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ReservationCodec =
      software.amazon.awssdk.services.medialive.model.ReservationCodec.AVC
  }
  case object HEVC extends zio.aws.medialive.model.ReservationCodec {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ReservationCodec =
      software.amazon.awssdk.services.medialive.model.ReservationCodec.HEVC
  }
  case object AUDIO extends zio.aws.medialive.model.ReservationCodec {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ReservationCodec =
      software.amazon.awssdk.services.medialive.model.ReservationCodec.AUDIO
  }
  case object LINK extends zio.aws.medialive.model.ReservationCodec {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ReservationCodec =
      software.amazon.awssdk.services.medialive.model.ReservationCodec.LINK
  }
}
