package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait ReservationMaximumBitrate {
  def unwrap: software.amazon.awssdk.services.medialive.model.ReservationMaximumBitrate
}
object ReservationMaximumBitrate {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.ReservationMaximumBitrate
  ): zio.aws.medialive.model.ReservationMaximumBitrate = value match {
    case software.amazon.awssdk.services.medialive.model.ReservationMaximumBitrate.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.ReservationMaximumBitrate.MAX_10_MBPS =>
      val r = MAX_10_MBPS
      r
    case software.amazon.awssdk.services.medialive.model.ReservationMaximumBitrate.MAX_20_MBPS =>
      val r = MAX_20_MBPS
      r
    case software.amazon.awssdk.services.medialive.model.ReservationMaximumBitrate.MAX_50_MBPS =>
      val r = MAX_50_MBPS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.ReservationMaximumBitrate {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ReservationMaximumBitrate =
      software.amazon.awssdk.services.medialive.model.ReservationMaximumBitrate.UNKNOWN_TO_SDK_VERSION
  }
  case object MAX_10_MBPS
      extends zio.aws.medialive.model.ReservationMaximumBitrate {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ReservationMaximumBitrate =
      software.amazon.awssdk.services.medialive.model.ReservationMaximumBitrate.MAX_10_MBPS
  }
  case object MAX_20_MBPS
      extends zio.aws.medialive.model.ReservationMaximumBitrate {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ReservationMaximumBitrate =
      software.amazon.awssdk.services.medialive.model.ReservationMaximumBitrate.MAX_20_MBPS
  }
  case object MAX_50_MBPS
      extends zio.aws.medialive.model.ReservationMaximumBitrate {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ReservationMaximumBitrate =
      software.amazon.awssdk.services.medialive.model.ReservationMaximumBitrate.MAX_50_MBPS
  }
}
