package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait ReservationMaximumFramerate {
  def unwrap: software.amazon.awssdk.services.medialive.model.ReservationMaximumFramerate
}
object ReservationMaximumFramerate {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.ReservationMaximumFramerate
  ): zio.aws.medialive.model.ReservationMaximumFramerate = value match {
    case software.amazon.awssdk.services.medialive.model.ReservationMaximumFramerate.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.ReservationMaximumFramerate.MAX_30_FPS =>
      val r = MAX_30_FPS
      r
    case software.amazon.awssdk.services.medialive.model.ReservationMaximumFramerate.MAX_60_FPS =>
      val r = MAX_60_FPS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.ReservationMaximumFramerate {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ReservationMaximumFramerate =
      software.amazon.awssdk.services.medialive.model.ReservationMaximumFramerate.UNKNOWN_TO_SDK_VERSION
  }
  case object MAX_30_FPS
      extends zio.aws.medialive.model.ReservationMaximumFramerate {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ReservationMaximumFramerate =
      software.amazon.awssdk.services.medialive.model.ReservationMaximumFramerate.MAX_30_FPS
  }
  case object MAX_60_FPS
      extends zio.aws.medialive.model.ReservationMaximumFramerate {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ReservationMaximumFramerate =
      software.amazon.awssdk.services.medialive.model.ReservationMaximumFramerate.MAX_60_FPS
  }
}
