package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait ReservationResolution {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.ReservationResolution
}
object ReservationResolution {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.ReservationResolution
  ): zio.aws.medialive.model.ReservationResolution = value match {
    case software.amazon.awssdk.services.medialive.model.ReservationResolution.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.ReservationResolution.SD =>
      val r = SD
      r
    case software.amazon.awssdk.services.medialive.model.ReservationResolution.HD =>
      val r = HD
      r
    case software.amazon.awssdk.services.medialive.model.ReservationResolution.FHD =>
      val r = FHD
      r
    case software.amazon.awssdk.services.medialive.model.ReservationResolution.UHD =>
      val r = UHD
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.ReservationResolution {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ReservationResolution =
      software.amazon.awssdk.services.medialive.model.ReservationResolution.UNKNOWN_TO_SDK_VERSION
  }
  case object SD extends zio.aws.medialive.model.ReservationResolution {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ReservationResolution =
      software.amazon.awssdk.services.medialive.model.ReservationResolution.SD
  }
  case object HD extends zio.aws.medialive.model.ReservationResolution {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ReservationResolution =
      software.amazon.awssdk.services.medialive.model.ReservationResolution.HD
  }
  case object FHD extends zio.aws.medialive.model.ReservationResolution {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ReservationResolution =
      software.amazon.awssdk.services.medialive.model.ReservationResolution.FHD
  }
  case object UHD extends zio.aws.medialive.model.ReservationResolution {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ReservationResolution =
      software.amazon.awssdk.services.medialive.model.ReservationResolution.UHD
  }
}
