package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ReservationResourceSpecification(
    channelClass: Option[zio.aws.medialive.model.ChannelClass] = None,
    codec: Option[zio.aws.medialive.model.ReservationCodec] = None,
    maximumBitrate: Option[zio.aws.medialive.model.ReservationMaximumBitrate] =
      None,
    maximumFramerate: Option[
      zio.aws.medialive.model.ReservationMaximumFramerate
    ] = None,
    resolution: Option[zio.aws.medialive.model.ReservationResolution] = None,
    resourceType: Option[zio.aws.medialive.model.ReservationResourceType] =
      None,
    specialFeature: Option[zio.aws.medialive.model.ReservationSpecialFeature] =
      None,
    videoQuality: Option[zio.aws.medialive.model.ReservationVideoQuality] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.ReservationResourceSpecification = {
    import ReservationResourceSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.ReservationResourceSpecification
      .builder()
      .optionallyWith(channelClass.map(value => value.unwrap))(_.channelClass)
      .optionallyWith(codec.map(value => value.unwrap))(_.codec)
      .optionallyWith(maximumBitrate.map(value => value.unwrap))(
        _.maximumBitrate
      )
      .optionallyWith(maximumFramerate.map(value => value.unwrap))(
        _.maximumFramerate
      )
      .optionallyWith(resolution.map(value => value.unwrap))(_.resolution)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(specialFeature.map(value => value.unwrap))(
        _.specialFeature
      )
      .optionallyWith(videoQuality.map(value => value.unwrap))(_.videoQuality)
      .build()
  }
  def asReadOnly
      : zio.aws.medialive.model.ReservationResourceSpecification.ReadOnly =
    zio.aws.medialive.model.ReservationResourceSpecification
      .wrap(buildAwsValue())
}
object ReservationResourceSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.ReservationResourceSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.ReservationResourceSpecification =
      zio.aws.medialive.model.ReservationResourceSpecification(
        channelClass.map(value => value),
        codec.map(value => value),
        maximumBitrate.map(value => value),
        maximumFramerate.map(value => value),
        resolution.map(value => value),
        resourceType.map(value => value),
        specialFeature.map(value => value),
        videoQuality.map(value => value)
      )
    def channelClass: Option[zio.aws.medialive.model.ChannelClass]
    def codec: Option[zio.aws.medialive.model.ReservationCodec]
    def maximumBitrate
        : Option[zio.aws.medialive.model.ReservationMaximumBitrate]
    def maximumFramerate
        : Option[zio.aws.medialive.model.ReservationMaximumFramerate]
    def resolution: Option[zio.aws.medialive.model.ReservationResolution]
    def resourceType: Option[zio.aws.medialive.model.ReservationResourceType]
    def specialFeature
        : Option[zio.aws.medialive.model.ReservationSpecialFeature]
    def videoQuality: Option[zio.aws.medialive.model.ReservationVideoQuality]
    def getChannelClass
        : ZIO[Any, AwsError, zio.aws.medialive.model.ChannelClass] =
      AwsError.unwrapOptionField("channelClass", channelClass)
    def getCodec: ZIO[Any, AwsError, zio.aws.medialive.model.ReservationCodec] =
      AwsError.unwrapOptionField("codec", codec)
    def getMaximumBitrate: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.ReservationMaximumBitrate
    ] = AwsError.unwrapOptionField("maximumBitrate", maximumBitrate)
    def getMaximumFramerate: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.ReservationMaximumFramerate
    ] = AwsError.unwrapOptionField("maximumFramerate", maximumFramerate)
    def getResolution
        : ZIO[Any, AwsError, zio.aws.medialive.model.ReservationResolution] =
      AwsError.unwrapOptionField("resolution", resolution)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.medialive.model.ReservationResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getSpecialFeature: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.ReservationSpecialFeature
    ] = AwsError.unwrapOptionField("specialFeature", specialFeature)
    def getVideoQuality
        : ZIO[Any, AwsError, zio.aws.medialive.model.ReservationVideoQuality] =
      AwsError.unwrapOptionField("videoQuality", videoQuality)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.ReservationResourceSpecification
  ) extends zio.aws.medialive.model.ReservationResourceSpecification.ReadOnly {
    override val channelClass: Option[zio.aws.medialive.model.ChannelClass] =
      scala
        .Option(impl.channelClass())
        .map(value => zio.aws.medialive.model.ChannelClass.wrap(value))
    override val codec: Option[zio.aws.medialive.model.ReservationCodec] = scala
      .Option(impl.codec())
      .map(value => zio.aws.medialive.model.ReservationCodec.wrap(value))
    override val maximumBitrate
        : Option[zio.aws.medialive.model.ReservationMaximumBitrate] = scala
      .Option(impl.maximumBitrate())
      .map(value =>
        zio.aws.medialive.model.ReservationMaximumBitrate.wrap(value)
      )
    override val maximumFramerate
        : Option[zio.aws.medialive.model.ReservationMaximumFramerate] = scala
      .Option(impl.maximumFramerate())
      .map(value =>
        zio.aws.medialive.model.ReservationMaximumFramerate.wrap(value)
      )
    override val resolution
        : Option[zio.aws.medialive.model.ReservationResolution] = scala
      .Option(impl.resolution())
      .map(value => zio.aws.medialive.model.ReservationResolution.wrap(value))
    override val resourceType
        : Option[zio.aws.medialive.model.ReservationResourceType] = scala
      .Option(impl.resourceType())
      .map(value => zio.aws.medialive.model.ReservationResourceType.wrap(value))
    override val specialFeature
        : Option[zio.aws.medialive.model.ReservationSpecialFeature] = scala
      .Option(impl.specialFeature())
      .map(value =>
        zio.aws.medialive.model.ReservationSpecialFeature.wrap(value)
      )
    override val videoQuality
        : Option[zio.aws.medialive.model.ReservationVideoQuality] = scala
      .Option(impl.videoQuality())
      .map(value => zio.aws.medialive.model.ReservationVideoQuality.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.ReservationResourceSpecification
  ): zio.aws.medialive.model.ReservationResourceSpecification.ReadOnly =
    new Wrapper(impl)
}
