package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait ReservationResourceType {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.ReservationResourceType
}
object ReservationResourceType {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.ReservationResourceType
  ): zio.aws.medialive.model.ReservationResourceType = value match {
    case software.amazon.awssdk.services.medialive.model.ReservationResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.ReservationResourceType.INPUT =>
      val r = INPUT
      r
    case software.amazon.awssdk.services.medialive.model.ReservationResourceType.OUTPUT =>
      val r = OUTPUT
      r
    case software.amazon.awssdk.services.medialive.model.ReservationResourceType.MULTIPLEX =>
      val r = MULTIPLEX
      r
    case software.amazon.awssdk.services.medialive.model.ReservationResourceType.CHANNEL =>
      val r = CHANNEL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.ReservationResourceType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ReservationResourceType =
      software.amazon.awssdk.services.medialive.model.ReservationResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object INPUT extends zio.aws.medialive.model.ReservationResourceType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ReservationResourceType =
      software.amazon.awssdk.services.medialive.model.ReservationResourceType.INPUT
  }
  case object OUTPUT extends zio.aws.medialive.model.ReservationResourceType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ReservationResourceType =
      software.amazon.awssdk.services.medialive.model.ReservationResourceType.OUTPUT
  }
  case object MULTIPLEX
      extends zio.aws.medialive.model.ReservationResourceType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ReservationResourceType =
      software.amazon.awssdk.services.medialive.model.ReservationResourceType.MULTIPLEX
  }
  case object CHANNEL extends zio.aws.medialive.model.ReservationResourceType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ReservationResourceType =
      software.amazon.awssdk.services.medialive.model.ReservationResourceType.CHANNEL
  }
}
