package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait ReservationSpecialFeature {
  def unwrap: software.amazon.awssdk.services.medialive.model.ReservationSpecialFeature
}
object ReservationSpecialFeature {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.ReservationSpecialFeature
  ): zio.aws.medialive.model.ReservationSpecialFeature = value match {
    case software.amazon.awssdk.services.medialive.model.ReservationSpecialFeature.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.ReservationSpecialFeature.ADVANCED_AUDIO =>
      val r = ADVANCED_AUDIO
      r
    case software.amazon.awssdk.services.medialive.model.ReservationSpecialFeature.AUDIO_NORMALIZATION =>
      val r = AUDIO_NORMALIZATION
      r
    case software.amazon.awssdk.services.medialive.model.ReservationSpecialFeature.MGHD =>
      val r = MGHD
      r
    case software.amazon.awssdk.services.medialive.model.ReservationSpecialFeature.MGUHD =>
      val r = MGUHD
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.ReservationSpecialFeature {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ReservationSpecialFeature =
      software.amazon.awssdk.services.medialive.model.ReservationSpecialFeature.UNKNOWN_TO_SDK_VERSION
  }
  case object ADVANCED_AUDIO
      extends zio.aws.medialive.model.ReservationSpecialFeature {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ReservationSpecialFeature =
      software.amazon.awssdk.services.medialive.model.ReservationSpecialFeature.ADVANCED_AUDIO
  }
  case object AUDIO_NORMALIZATION
      extends zio.aws.medialive.model.ReservationSpecialFeature {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ReservationSpecialFeature =
      software.amazon.awssdk.services.medialive.model.ReservationSpecialFeature.AUDIO_NORMALIZATION
  }
  case object MGHD extends zio.aws.medialive.model.ReservationSpecialFeature {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ReservationSpecialFeature =
      software.amazon.awssdk.services.medialive.model.ReservationSpecialFeature.MGHD
  }
  case object MGUHD extends zio.aws.medialive.model.ReservationSpecialFeature {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ReservationSpecialFeature =
      software.amazon.awssdk.services.medialive.model.ReservationSpecialFeature.MGUHD
  }
}
