package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait ReservationState {
  def unwrap: software.amazon.awssdk.services.medialive.model.ReservationState
}
object ReservationState {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.ReservationState
  ): zio.aws.medialive.model.ReservationState = value match {
    case software.amazon.awssdk.services.medialive.model.ReservationState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.ReservationState.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.medialive.model.ReservationState.EXPIRED =>
      val r = EXPIRED
      r
    case software.amazon.awssdk.services.medialive.model.ReservationState.CANCELED =>
      val r = CANCELED
      r
    case software.amazon.awssdk.services.medialive.model.ReservationState.DELETED =>
      val r = DELETED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.ReservationState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ReservationState =
      software.amazon.awssdk.services.medialive.model.ReservationState.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.medialive.model.ReservationState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ReservationState =
      software.amazon.awssdk.services.medialive.model.ReservationState.ACTIVE
  }
  case object EXPIRED extends zio.aws.medialive.model.ReservationState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ReservationState =
      software.amazon.awssdk.services.medialive.model.ReservationState.EXPIRED
  }
  case object CANCELED extends zio.aws.medialive.model.ReservationState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ReservationState =
      software.amazon.awssdk.services.medialive.model.ReservationState.CANCELED
  }
  case object DELETED extends zio.aws.medialive.model.ReservationState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ReservationState =
      software.amazon.awssdk.services.medialive.model.ReservationState.DELETED
  }
}
