package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait ReservationVideoQuality {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.ReservationVideoQuality
}
object ReservationVideoQuality {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.ReservationVideoQuality
  ): zio.aws.medialive.model.ReservationVideoQuality = value match {
    case software.amazon.awssdk.services.medialive.model.ReservationVideoQuality.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.ReservationVideoQuality.STANDARD =>
      val r = STANDARD
      r
    case software.amazon.awssdk.services.medialive.model.ReservationVideoQuality.ENHANCED =>
      val r = ENHANCED
      r
    case software.amazon.awssdk.services.medialive.model.ReservationVideoQuality.PREMIUM =>
      val r = PREMIUM
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.ReservationVideoQuality {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ReservationVideoQuality =
      software.amazon.awssdk.services.medialive.model.ReservationVideoQuality.UNKNOWN_TO_SDK_VERSION
  }
  case object STANDARD extends zio.aws.medialive.model.ReservationVideoQuality {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ReservationVideoQuality =
      software.amazon.awssdk.services.medialive.model.ReservationVideoQuality.STANDARD
  }
  case object ENHANCED extends zio.aws.medialive.model.ReservationVideoQuality {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ReservationVideoQuality =
      software.amazon.awssdk.services.medialive.model.ReservationVideoQuality.ENHANCED
  }
  case object PREMIUM extends zio.aws.medialive.model.ReservationVideoQuality {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.ReservationVideoQuality =
      software.amazon.awssdk.services.medialive.model.ReservationVideoQuality.PREMIUM
  }
}
