package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait RtmpAdMarkers {
  def unwrap: software.amazon.awssdk.services.medialive.model.RtmpAdMarkers
}
object RtmpAdMarkers {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.RtmpAdMarkers
  ): zio.aws.medialive.model.RtmpAdMarkers = value match {
    case software.amazon.awssdk.services.medialive.model.RtmpAdMarkers.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.RtmpAdMarkers.ON_CUE_POINT_SCTE35 =>
      val r = ON_CUE_POINT_SCTE35
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.RtmpAdMarkers {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.RtmpAdMarkers =
      software.amazon.awssdk.services.medialive.model.RtmpAdMarkers.UNKNOWN_TO_SDK_VERSION
  }
  case object ON_CUE_POINT_SCTE35
      extends zio.aws.medialive.model.RtmpAdMarkers {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.RtmpAdMarkers =
      software.amazon.awssdk.services.medialive.model.RtmpAdMarkers.ON_CUE_POINT_SCTE35
  }
}
