package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait RtmpCacheFullBehavior {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.RtmpCacheFullBehavior
}
object RtmpCacheFullBehavior {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.RtmpCacheFullBehavior
  ): zio.aws.medialive.model.RtmpCacheFullBehavior = value match {
    case software.amazon.awssdk.services.medialive.model.RtmpCacheFullBehavior.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.RtmpCacheFullBehavior.DISCONNECT_IMMEDIATELY =>
      val r = DISCONNECT_IMMEDIATELY
      r
    case software.amazon.awssdk.services.medialive.model.RtmpCacheFullBehavior.WAIT_FOR_SERVER =>
      val r = WAIT_FOR_SERVER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.RtmpCacheFullBehavior {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.RtmpCacheFullBehavior =
      software.amazon.awssdk.services.medialive.model.RtmpCacheFullBehavior.UNKNOWN_TO_SDK_VERSION
  }
  case object DISCONNECT_IMMEDIATELY
      extends zio.aws.medialive.model.RtmpCacheFullBehavior {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.RtmpCacheFullBehavior =
      software.amazon.awssdk.services.medialive.model.RtmpCacheFullBehavior.DISCONNECT_IMMEDIATELY
  }
  case object WAIT_FOR_SERVER
      extends zio.aws.medialive.model.RtmpCacheFullBehavior {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.RtmpCacheFullBehavior =
      software.amazon.awssdk.services.medialive.model.RtmpCacheFullBehavior.WAIT_FOR_SERVER
  }
}
