package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait RtmpCaptionData {
  def unwrap: software.amazon.awssdk.services.medialive.model.RtmpCaptionData
}
object RtmpCaptionData {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.RtmpCaptionData
  ): zio.aws.medialive.model.RtmpCaptionData = value match {
    case software.amazon.awssdk.services.medialive.model.RtmpCaptionData.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.RtmpCaptionData.ALL =>
      val r = ALL
      r
    case software.amazon.awssdk.services.medialive.model.RtmpCaptionData.FIELD1_608 =>
      val r = FIELD1_608
      r
    case software.amazon.awssdk.services.medialive.model.RtmpCaptionData.FIELD1_AND_FIELD2_608 =>
      val r = FIELD1_AND_FIELD2_608
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.RtmpCaptionData {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.RtmpCaptionData =
      software.amazon.awssdk.services.medialive.model.RtmpCaptionData.UNKNOWN_TO_SDK_VERSION
  }
  case object ALL extends zio.aws.medialive.model.RtmpCaptionData {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.RtmpCaptionData =
      software.amazon.awssdk.services.medialive.model.RtmpCaptionData.ALL
  }
  case object FIELD1_608 extends zio.aws.medialive.model.RtmpCaptionData {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.RtmpCaptionData =
      software.amazon.awssdk.services.medialive.model.RtmpCaptionData.FIELD1_608
  }
  case object FIELD1_AND_FIELD2_608
      extends zio.aws.medialive.model.RtmpCaptionData {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.RtmpCaptionData =
      software.amazon.awssdk.services.medialive.model.RtmpCaptionData.FIELD1_AND_FIELD2_608
  }
}
