package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{__integerMin0, __integerMin30}
import scala.jdk.CollectionConverters._
final case class RtmpGroupSettings(
    adMarkers: Option[Iterable[zio.aws.medialive.model.RtmpAdMarkers]] = None,
    authenticationScheme: Option[zio.aws.medialive.model.AuthenticationScheme] =
      None,
    cacheFullBehavior: Option[zio.aws.medialive.model.RtmpCacheFullBehavior] =
      None,
    cacheLength: Option[__integerMin30] = None,
    captionData: Option[zio.aws.medialive.model.RtmpCaptionData] = None,
    inputLossAction: Option[zio.aws.medialive.model.InputLossActionForRtmpOut] =
      None,
    restartDelay: Option[__integerMin0] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.RtmpGroupSettings = {
    import RtmpGroupSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.RtmpGroupSettings
      .builder()
      .optionallyWith(
        adMarkers.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.adMarkersWithStrings)
      .optionallyWith(authenticationScheme.map(value => value.unwrap))(
        _.authenticationScheme
      )
      .optionallyWith(cacheFullBehavior.map(value => value.unwrap))(
        _.cacheFullBehavior
      )
      .optionallyWith(cacheLength.map(value => value: Integer))(_.cacheLength)
      .optionallyWith(captionData.map(value => value.unwrap))(_.captionData)
      .optionallyWith(inputLossAction.map(value => value.unwrap))(
        _.inputLossAction
      )
      .optionallyWith(restartDelay.map(value => value: Integer))(_.restartDelay)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.RtmpGroupSettings.ReadOnly =
    zio.aws.medialive.model.RtmpGroupSettings.wrap(buildAwsValue())
}
object RtmpGroupSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.RtmpGroupSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.RtmpGroupSettings =
      zio.aws.medialive.model.RtmpGroupSettings(
        adMarkers.map(value => value),
        authenticationScheme.map(value => value),
        cacheFullBehavior.map(value => value),
        cacheLength.map(value => value),
        captionData.map(value => value),
        inputLossAction.map(value => value),
        restartDelay.map(value => value)
      )
    def adMarkers: Option[List[zio.aws.medialive.model.RtmpAdMarkers]]
    def authenticationScheme
        : Option[zio.aws.medialive.model.AuthenticationScheme]
    def cacheFullBehavior: Option[zio.aws.medialive.model.RtmpCacheFullBehavior]
    def cacheLength: Option[__integerMin30]
    def captionData: Option[zio.aws.medialive.model.RtmpCaptionData]
    def inputLossAction
        : Option[zio.aws.medialive.model.InputLossActionForRtmpOut]
    def restartDelay: Option[__integerMin0]
    def getAdMarkers
        : ZIO[Any, AwsError, List[zio.aws.medialive.model.RtmpAdMarkers]] =
      AwsError.unwrapOptionField("adMarkers", adMarkers)
    def getAuthenticationScheme
        : ZIO[Any, AwsError, zio.aws.medialive.model.AuthenticationScheme] =
      AwsError.unwrapOptionField("authenticationScheme", authenticationScheme)
    def getCacheFullBehavior
        : ZIO[Any, AwsError, zio.aws.medialive.model.RtmpCacheFullBehavior] =
      AwsError.unwrapOptionField("cacheFullBehavior", cacheFullBehavior)
    def getCacheLength: ZIO[Any, AwsError, __integerMin30] =
      AwsError.unwrapOptionField("cacheLength", cacheLength)
    def getCaptionData
        : ZIO[Any, AwsError, zio.aws.medialive.model.RtmpCaptionData] =
      AwsError.unwrapOptionField("captionData", captionData)
    def getInputLossAction: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.InputLossActionForRtmpOut
    ] = AwsError.unwrapOptionField("inputLossAction", inputLossAction)
    def getRestartDelay: ZIO[Any, AwsError, __integerMin0] =
      AwsError.unwrapOptionField("restartDelay", restartDelay)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.RtmpGroupSettings
  ) extends zio.aws.medialive.model.RtmpGroupSettings.ReadOnly {
    override val adMarkers
        : Option[List[zio.aws.medialive.model.RtmpAdMarkers]] = scala
      .Option(impl.adMarkers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.medialive.model.RtmpAdMarkers.wrap(item)
        }.toList
      )
    override val authenticationScheme
        : Option[zio.aws.medialive.model.AuthenticationScheme] = scala
      .Option(impl.authenticationScheme())
      .map(value => zio.aws.medialive.model.AuthenticationScheme.wrap(value))
    override val cacheFullBehavior
        : Option[zio.aws.medialive.model.RtmpCacheFullBehavior] = scala
      .Option(impl.cacheFullBehavior())
      .map(value => zio.aws.medialive.model.RtmpCacheFullBehavior.wrap(value))
    override val cacheLength: Option[__integerMin30] =
      scala.Option(impl.cacheLength()).map(value => value: __integerMin30)
    override val captionData: Option[zio.aws.medialive.model.RtmpCaptionData] =
      scala
        .Option(impl.captionData())
        .map(value => zio.aws.medialive.model.RtmpCaptionData.wrap(value))
    override val inputLossAction
        : Option[zio.aws.medialive.model.InputLossActionForRtmpOut] = scala
      .Option(impl.inputLossAction())
      .map(value =>
        zio.aws.medialive.model.InputLossActionForRtmpOut.wrap(value)
      )
    override val restartDelay: Option[__integerMin0] =
      scala.Option(impl.restartDelay()).map(value => value: __integerMin0)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.RtmpGroupSettings
  ): zio.aws.medialive.model.RtmpGroupSettings.ReadOnly = new Wrapper(impl)
}
