package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{__integerMin0, __integerMin1}
import scala.jdk.CollectionConverters._
final case class RtmpOutputSettings(
    certificateMode: Option[zio.aws.medialive.model.RtmpOutputCertificateMode] =
      None,
    connectionRetryInterval: Option[__integerMin1] = None,
    destination: zio.aws.medialive.model.OutputLocationRef,
    numRetries: Option[__integerMin0] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.RtmpOutputSettings = {
    import RtmpOutputSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.RtmpOutputSettings
      .builder()
      .optionallyWith(certificateMode.map(value => value.unwrap))(
        _.certificateMode
      )
      .optionallyWith(connectionRetryInterval.map(value => value: Integer))(
        _.connectionRetryInterval
      )
      .destination(destination.buildAwsValue())
      .optionallyWith(numRetries.map(value => value: Integer))(_.numRetries)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.RtmpOutputSettings.ReadOnly =
    zio.aws.medialive.model.RtmpOutputSettings.wrap(buildAwsValue())
}
object RtmpOutputSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.RtmpOutputSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.RtmpOutputSettings =
      zio.aws.medialive.model.RtmpOutputSettings(
        certificateMode.map(value => value),
        connectionRetryInterval.map(value => value),
        destination.asEditable,
        numRetries.map(value => value)
      )
    def certificateMode
        : Option[zio.aws.medialive.model.RtmpOutputCertificateMode]
    def connectionRetryInterval: Option[__integerMin1]
    def destination: zio.aws.medialive.model.OutputLocationRef.ReadOnly
    def numRetries: Option[__integerMin0]
    def getCertificateMode: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.RtmpOutputCertificateMode
    ] = AwsError.unwrapOptionField("certificateMode", certificateMode)
    def getConnectionRetryInterval: ZIO[Any, AwsError, __integerMin1] = AwsError
      .unwrapOptionField("connectionRetryInterval", connectionRetryInterval)
    def getDestination: ZIO[
      Any,
      Nothing,
      zio.aws.medialive.model.OutputLocationRef.ReadOnly
    ] = ZIO.succeed(destination)
    def getNumRetries: ZIO[Any, AwsError, __integerMin0] =
      AwsError.unwrapOptionField("numRetries", numRetries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.RtmpOutputSettings
  ) extends zio.aws.medialive.model.RtmpOutputSettings.ReadOnly {
    override val certificateMode
        : Option[zio.aws.medialive.model.RtmpOutputCertificateMode] = scala
      .Option(impl.certificateMode())
      .map(value =>
        zio.aws.medialive.model.RtmpOutputCertificateMode.wrap(value)
      )
    override val connectionRetryInterval: Option[__integerMin1] = scala
      .Option(impl.connectionRetryInterval())
      .map(value => value: __integerMin1)
    override val destination
        : zio.aws.medialive.model.OutputLocationRef.ReadOnly =
      zio.aws.medialive.model.OutputLocationRef.wrap(impl.destination())
    override val numRetries: Option[__integerMin0] =
      scala.Option(impl.numRetries()).map(value => value: __integerMin0)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.RtmpOutputSettings
  ): zio.aws.medialive.model.RtmpOutputSettings.ReadOnly = new Wrapper(impl)
}
