package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait S3CannedAcl {
  def unwrap: software.amazon.awssdk.services.medialive.model.S3CannedAcl
}
object S3CannedAcl {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.S3CannedAcl
  ): zio.aws.medialive.model.S3CannedAcl = value match {
    case software.amazon.awssdk.services.medialive.model.S3CannedAcl.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.S3CannedAcl.AUTHENTICATED_READ =>
      val r = AUTHENTICATED_READ
      r
    case software.amazon.awssdk.services.medialive.model.S3CannedAcl.BUCKET_OWNER_FULL_CONTROL =>
      val r = BUCKET_OWNER_FULL_CONTROL
      r
    case software.amazon.awssdk.services.medialive.model.S3CannedAcl.BUCKET_OWNER_READ =>
      val r = BUCKET_OWNER_READ
      r
    case software.amazon.awssdk.services.medialive.model.S3CannedAcl.PUBLIC_READ =>
      val r = PUBLIC_READ
      r
  }
  case object unknownToSdkVersion extends zio.aws.medialive.model.S3CannedAcl {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.S3CannedAcl =
      software.amazon.awssdk.services.medialive.model.S3CannedAcl.UNKNOWN_TO_SDK_VERSION
  }
  case object AUTHENTICATED_READ extends zio.aws.medialive.model.S3CannedAcl {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.S3CannedAcl =
      software.amazon.awssdk.services.medialive.model.S3CannedAcl.AUTHENTICATED_READ
  }
  case object BUCKET_OWNER_FULL_CONTROL
      extends zio.aws.medialive.model.S3CannedAcl {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.S3CannedAcl =
      software.amazon.awssdk.services.medialive.model.S3CannedAcl.BUCKET_OWNER_FULL_CONTROL
  }
  case object BUCKET_OWNER_READ extends zio.aws.medialive.model.S3CannedAcl {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.S3CannedAcl =
      software.amazon.awssdk.services.medialive.model.S3CannedAcl.BUCKET_OWNER_READ
  }
  case object PUBLIC_READ extends zio.aws.medialive.model.S3CannedAcl {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.S3CannedAcl =
      software.amazon.awssdk.services.medialive.model.S3CannedAcl.PUBLIC_READ
  }
}
