package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class ScheduleAction(
    actionName: __string,
    scheduleActionSettings: zio.aws.medialive.model.ScheduleActionSettings,
    scheduleActionStartSettings: zio.aws.medialive.model.ScheduleActionStartSettings
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.ScheduleAction = {
    import ScheduleAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.ScheduleAction
      .builder()
      .actionName(actionName: java.lang.String)
      .scheduleActionSettings(scheduleActionSettings.buildAwsValue())
      .scheduleActionStartSettings(scheduleActionStartSettings.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.ScheduleAction.ReadOnly =
    zio.aws.medialive.model.ScheduleAction.wrap(buildAwsValue())
}
object ScheduleAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.ScheduleAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.ScheduleAction =
      zio.aws.medialive.model.ScheduleAction(
        actionName,
        scheduleActionSettings.asEditable,
        scheduleActionStartSettings.asEditable
      )
    def actionName: __string
    def scheduleActionSettings
        : zio.aws.medialive.model.ScheduleActionSettings.ReadOnly
    def scheduleActionStartSettings
        : zio.aws.medialive.model.ScheduleActionStartSettings.ReadOnly
    def getActionName: ZIO[Any, Nothing, __string] = ZIO.succeed(actionName)
    def getScheduleActionSettings: ZIO[
      Any,
      Nothing,
      zio.aws.medialive.model.ScheduleActionSettings.ReadOnly
    ] = ZIO.succeed(scheduleActionSettings)
    def getScheduleActionStartSettings: ZIO[
      Any,
      Nothing,
      zio.aws.medialive.model.ScheduleActionStartSettings.ReadOnly
    ] = ZIO.succeed(scheduleActionStartSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.ScheduleAction
  ) extends zio.aws.medialive.model.ScheduleAction.ReadOnly {
    override val actionName: __string = impl.actionName(): __string
    override val scheduleActionSettings
        : zio.aws.medialive.model.ScheduleActionSettings.ReadOnly =
      zio.aws.medialive.model.ScheduleActionSettings
        .wrap(impl.scheduleActionSettings())
    override val scheduleActionStartSettings
        : zio.aws.medialive.model.ScheduleActionStartSettings.ReadOnly =
      zio.aws.medialive.model.ScheduleActionStartSettings
        .wrap(impl.scheduleActionStartSettings())
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.ScheduleAction
  ): zio.aws.medialive.model.ScheduleAction.ReadOnly = new Wrapper(impl)
}
