package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ScheduleActionSettings(
    hlsId3SegmentTaggingSettings: Option[
      zio.aws.medialive.model.HlsId3SegmentTaggingScheduleActionSettings
    ] = None,
    hlsTimedMetadataSettings: Option[
      zio.aws.medialive.model.HlsTimedMetadataScheduleActionSettings
    ] = None,
    inputPrepareSettings: Option[
      zio.aws.medialive.model.InputPrepareScheduleActionSettings
    ] = None,
    inputSwitchSettings: Option[
      zio.aws.medialive.model.InputSwitchScheduleActionSettings
    ] = None,
    motionGraphicsImageActivateSettings: Option[
      zio.aws.medialive.model.MotionGraphicsActivateScheduleActionSettings
    ] = None,
    motionGraphicsImageDeactivateSettings: Option[
      zio.aws.medialive.model.MotionGraphicsDeactivateScheduleActionSettings
    ] = None,
    pauseStateSettings: Option[
      zio.aws.medialive.model.PauseStateScheduleActionSettings
    ] = None,
    scte35ReturnToNetworkSettings: Option[
      zio.aws.medialive.model.Scte35ReturnToNetworkScheduleActionSettings
    ] = None,
    scte35SpliceInsertSettings: Option[
      zio.aws.medialive.model.Scte35SpliceInsertScheduleActionSettings
    ] = None,
    scte35TimeSignalSettings: Option[
      zio.aws.medialive.model.Scte35TimeSignalScheduleActionSettings
    ] = None,
    staticImageActivateSettings: Option[
      zio.aws.medialive.model.StaticImageActivateScheduleActionSettings
    ] = None,
    staticImageDeactivateSettings: Option[
      zio.aws.medialive.model.StaticImageDeactivateScheduleActionSettings
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.ScheduleActionSettings = {
    import ScheduleActionSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.ScheduleActionSettings
      .builder()
      .optionallyWith(
        hlsId3SegmentTaggingSettings.map(value => value.buildAwsValue())
      )(_.hlsId3SegmentTaggingSettings)
      .optionallyWith(
        hlsTimedMetadataSettings.map(value => value.buildAwsValue())
      )(_.hlsTimedMetadataSettings)
      .optionallyWith(inputPrepareSettings.map(value => value.buildAwsValue()))(
        _.inputPrepareSettings
      )
      .optionallyWith(inputSwitchSettings.map(value => value.buildAwsValue()))(
        _.inputSwitchSettings
      )
      .optionallyWith(
        motionGraphicsImageActivateSettings.map(value => value.buildAwsValue())
      )(_.motionGraphicsImageActivateSettings)
      .optionallyWith(
        motionGraphicsImageDeactivateSettings.map(value =>
          value.buildAwsValue()
        )
      )(_.motionGraphicsImageDeactivateSettings)
      .optionallyWith(pauseStateSettings.map(value => value.buildAwsValue()))(
        _.pauseStateSettings
      )
      .optionallyWith(
        scte35ReturnToNetworkSettings.map(value => value.buildAwsValue())
      )(_.scte35ReturnToNetworkSettings)
      .optionallyWith(
        scte35SpliceInsertSettings.map(value => value.buildAwsValue())
      )(_.scte35SpliceInsertSettings)
      .optionallyWith(
        scte35TimeSignalSettings.map(value => value.buildAwsValue())
      )(_.scte35TimeSignalSettings)
      .optionallyWith(
        staticImageActivateSettings.map(value => value.buildAwsValue())
      )(_.staticImageActivateSettings)
      .optionallyWith(
        staticImageDeactivateSettings.map(value => value.buildAwsValue())
      )(_.staticImageDeactivateSettings)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.ScheduleActionSettings.ReadOnly =
    zio.aws.medialive.model.ScheduleActionSettings.wrap(buildAwsValue())
}
object ScheduleActionSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.ScheduleActionSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.ScheduleActionSettings =
      zio.aws.medialive.model.ScheduleActionSettings(
        hlsId3SegmentTaggingSettings.map(value => value.asEditable),
        hlsTimedMetadataSettings.map(value => value.asEditable),
        inputPrepareSettings.map(value => value.asEditable),
        inputSwitchSettings.map(value => value.asEditable),
        motionGraphicsImageActivateSettings.map(value => value.asEditable),
        motionGraphicsImageDeactivateSettings.map(value => value.asEditable),
        pauseStateSettings.map(value => value.asEditable),
        scte35ReturnToNetworkSettings.map(value => value.asEditable),
        scte35SpliceInsertSettings.map(value => value.asEditable),
        scte35TimeSignalSettings.map(value => value.asEditable),
        staticImageActivateSettings.map(value => value.asEditable),
        staticImageDeactivateSettings.map(value => value.asEditable)
      )
    def hlsId3SegmentTaggingSettings: Option[
      zio.aws.medialive.model.HlsId3SegmentTaggingScheduleActionSettings.ReadOnly
    ]
    def hlsTimedMetadataSettings: Option[
      zio.aws.medialive.model.HlsTimedMetadataScheduleActionSettings.ReadOnly
    ]
    def inputPrepareSettings: Option[
      zio.aws.medialive.model.InputPrepareScheduleActionSettings.ReadOnly
    ]
    def inputSwitchSettings: Option[
      zio.aws.medialive.model.InputSwitchScheduleActionSettings.ReadOnly
    ]
    def motionGraphicsImageActivateSettings: Option[
      zio.aws.medialive.model.MotionGraphicsActivateScheduleActionSettings.ReadOnly
    ]
    def motionGraphicsImageDeactivateSettings: Option[
      zio.aws.medialive.model.MotionGraphicsDeactivateScheduleActionSettings.ReadOnly
    ]
    def pauseStateSettings: Option[
      zio.aws.medialive.model.PauseStateScheduleActionSettings.ReadOnly
    ]
    def scte35ReturnToNetworkSettings: Option[
      zio.aws.medialive.model.Scte35ReturnToNetworkScheduleActionSettings.ReadOnly
    ]
    def scte35SpliceInsertSettings: Option[
      zio.aws.medialive.model.Scte35SpliceInsertScheduleActionSettings.ReadOnly
    ]
    def scte35TimeSignalSettings: Option[
      zio.aws.medialive.model.Scte35TimeSignalScheduleActionSettings.ReadOnly
    ]
    def staticImageActivateSettings: Option[
      zio.aws.medialive.model.StaticImageActivateScheduleActionSettings.ReadOnly
    ]
    def staticImageDeactivateSettings: Option[
      zio.aws.medialive.model.StaticImageDeactivateScheduleActionSettings.ReadOnly
    ]
    def getHlsId3SegmentTaggingSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.HlsId3SegmentTaggingScheduleActionSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "hlsId3SegmentTaggingSettings",
      hlsId3SegmentTaggingSettings
    )
    def getHlsTimedMetadataSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.HlsTimedMetadataScheduleActionSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "hlsTimedMetadataSettings",
      hlsTimedMetadataSettings
    )
    def getInputPrepareSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.InputPrepareScheduleActionSettings.ReadOnly
    ] = AwsError.unwrapOptionField("inputPrepareSettings", inputPrepareSettings)
    def getInputSwitchSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.InputSwitchScheduleActionSettings.ReadOnly
    ] = AwsError.unwrapOptionField("inputSwitchSettings", inputSwitchSettings)
    def getMotionGraphicsImageActivateSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.MotionGraphicsActivateScheduleActionSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "motionGraphicsImageActivateSettings",
      motionGraphicsImageActivateSettings
    )
    def getMotionGraphicsImageDeactivateSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.MotionGraphicsDeactivateScheduleActionSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "motionGraphicsImageDeactivateSettings",
      motionGraphicsImageDeactivateSettings
    )
    def getPauseStateSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.PauseStateScheduleActionSettings.ReadOnly
    ] = AwsError.unwrapOptionField("pauseStateSettings", pauseStateSettings)
    def getScte35ReturnToNetworkSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.Scte35ReturnToNetworkScheduleActionSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "scte35ReturnToNetworkSettings",
      scte35ReturnToNetworkSettings
    )
    def getScte35SpliceInsertSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.Scte35SpliceInsertScheduleActionSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "scte35SpliceInsertSettings",
      scte35SpliceInsertSettings
    )
    def getScte35TimeSignalSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.Scte35TimeSignalScheduleActionSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "scte35TimeSignalSettings",
      scte35TimeSignalSettings
    )
    def getStaticImageActivateSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.StaticImageActivateScheduleActionSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "staticImageActivateSettings",
      staticImageActivateSettings
    )
    def getStaticImageDeactivateSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.StaticImageDeactivateScheduleActionSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "staticImageDeactivateSettings",
      staticImageDeactivateSettings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.ScheduleActionSettings
  ) extends zio.aws.medialive.model.ScheduleActionSettings.ReadOnly {
    override val hlsId3SegmentTaggingSettings: Option[
      zio.aws.medialive.model.HlsId3SegmentTaggingScheduleActionSettings.ReadOnly
    ] = scala
      .Option(impl.hlsId3SegmentTaggingSettings())
      .map(value =>
        zio.aws.medialive.model.HlsId3SegmentTaggingScheduleActionSettings
          .wrap(value)
      )
    override val hlsTimedMetadataSettings: Option[
      zio.aws.medialive.model.HlsTimedMetadataScheduleActionSettings.ReadOnly
    ] = scala
      .Option(impl.hlsTimedMetadataSettings())
      .map(value =>
        zio.aws.medialive.model.HlsTimedMetadataScheduleActionSettings
          .wrap(value)
      )
    override val inputPrepareSettings: Option[
      zio.aws.medialive.model.InputPrepareScheduleActionSettings.ReadOnly
    ] = scala
      .Option(impl.inputPrepareSettings())
      .map(value =>
        zio.aws.medialive.model.InputPrepareScheduleActionSettings.wrap(value)
      )
    override val inputSwitchSettings: Option[
      zio.aws.medialive.model.InputSwitchScheduleActionSettings.ReadOnly
    ] = scala
      .Option(impl.inputSwitchSettings())
      .map(value =>
        zio.aws.medialive.model.InputSwitchScheduleActionSettings.wrap(value)
      )
    override val motionGraphicsImageActivateSettings: Option[
      zio.aws.medialive.model.MotionGraphicsActivateScheduleActionSettings.ReadOnly
    ] = scala
      .Option(impl.motionGraphicsImageActivateSettings())
      .map(value =>
        zio.aws.medialive.model.MotionGraphicsActivateScheduleActionSettings
          .wrap(value)
      )
    override val motionGraphicsImageDeactivateSettings: Option[
      zio.aws.medialive.model.MotionGraphicsDeactivateScheduleActionSettings.ReadOnly
    ] = scala
      .Option(impl.motionGraphicsImageDeactivateSettings())
      .map(value =>
        zio.aws.medialive.model.MotionGraphicsDeactivateScheduleActionSettings
          .wrap(value)
      )
    override val pauseStateSettings: Option[
      zio.aws.medialive.model.PauseStateScheduleActionSettings.ReadOnly
    ] = scala
      .Option(impl.pauseStateSettings())
      .map(value =>
        zio.aws.medialive.model.PauseStateScheduleActionSettings.wrap(value)
      )
    override val scte35ReturnToNetworkSettings: Option[
      zio.aws.medialive.model.Scte35ReturnToNetworkScheduleActionSettings.ReadOnly
    ] = scala
      .Option(impl.scte35ReturnToNetworkSettings())
      .map(value =>
        zio.aws.medialive.model.Scte35ReturnToNetworkScheduleActionSettings
          .wrap(value)
      )
    override val scte35SpliceInsertSettings: Option[
      zio.aws.medialive.model.Scte35SpliceInsertScheduleActionSettings.ReadOnly
    ] = scala
      .Option(impl.scte35SpliceInsertSettings())
      .map(value =>
        zio.aws.medialive.model.Scte35SpliceInsertScheduleActionSettings
          .wrap(value)
      )
    override val scte35TimeSignalSettings: Option[
      zio.aws.medialive.model.Scte35TimeSignalScheduleActionSettings.ReadOnly
    ] = scala
      .Option(impl.scte35TimeSignalSettings())
      .map(value =>
        zio.aws.medialive.model.Scte35TimeSignalScheduleActionSettings
          .wrap(value)
      )
    override val staticImageActivateSettings: Option[
      zio.aws.medialive.model.StaticImageActivateScheduleActionSettings.ReadOnly
    ] = scala
      .Option(impl.staticImageActivateSettings())
      .map(value =>
        zio.aws.medialive.model.StaticImageActivateScheduleActionSettings
          .wrap(value)
      )
    override val staticImageDeactivateSettings: Option[
      zio.aws.medialive.model.StaticImageDeactivateScheduleActionSettings.ReadOnly
    ] = scala
      .Option(impl.staticImageDeactivateSettings())
      .map(value =>
        zio.aws.medialive.model.StaticImageDeactivateScheduleActionSettings
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.ScheduleActionSettings
  ): zio.aws.medialive.model.ScheduleActionSettings.ReadOnly = new Wrapper(impl)
}
