package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ScheduleActionStartSettings(
    fixedModeScheduleActionStartSettings: Option[
      zio.aws.medialive.model.FixedModeScheduleActionStartSettings
    ] = None,
    followModeScheduleActionStartSettings: Option[
      zio.aws.medialive.model.FollowModeScheduleActionStartSettings
    ] = None,
    immediateModeScheduleActionStartSettings: Option[
      zio.aws.medialive.model.ImmediateModeScheduleActionStartSettings
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.ScheduleActionStartSettings = {
    import ScheduleActionStartSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.ScheduleActionStartSettings
      .builder()
      .optionallyWith(
        fixedModeScheduleActionStartSettings.map(value => value.buildAwsValue())
      )(_.fixedModeScheduleActionStartSettings)
      .optionallyWith(
        followModeScheduleActionStartSettings.map(value =>
          value.buildAwsValue()
        )
      )(_.followModeScheduleActionStartSettings)
      .optionallyWith(
        immediateModeScheduleActionStartSettings.map(value =>
          value.buildAwsValue()
        )
      )(_.immediateModeScheduleActionStartSettings)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.ScheduleActionStartSettings.ReadOnly =
    zio.aws.medialive.model.ScheduleActionStartSettings.wrap(buildAwsValue())
}
object ScheduleActionStartSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.ScheduleActionStartSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.ScheduleActionStartSettings =
      zio.aws.medialive.model.ScheduleActionStartSettings(
        fixedModeScheduleActionStartSettings.map(value => value.asEditable),
        followModeScheduleActionStartSettings.map(value => value.asEditable),
        immediateModeScheduleActionStartSettings.map(value => value.asEditable)
      )
    def fixedModeScheduleActionStartSettings: Option[
      zio.aws.medialive.model.FixedModeScheduleActionStartSettings.ReadOnly
    ]
    def followModeScheduleActionStartSettings: Option[
      zio.aws.medialive.model.FollowModeScheduleActionStartSettings.ReadOnly
    ]
    def immediateModeScheduleActionStartSettings: Option[
      zio.aws.medialive.model.ImmediateModeScheduleActionStartSettings.ReadOnly
    ]
    def getFixedModeScheduleActionStartSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.FixedModeScheduleActionStartSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "fixedModeScheduleActionStartSettings",
      fixedModeScheduleActionStartSettings
    )
    def getFollowModeScheduleActionStartSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.FollowModeScheduleActionStartSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "followModeScheduleActionStartSettings",
      followModeScheduleActionStartSettings
    )
    def getImmediateModeScheduleActionStartSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.ImmediateModeScheduleActionStartSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "immediateModeScheduleActionStartSettings",
      immediateModeScheduleActionStartSettings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.ScheduleActionStartSettings
  ) extends zio.aws.medialive.model.ScheduleActionStartSettings.ReadOnly {
    override val fixedModeScheduleActionStartSettings: Option[
      zio.aws.medialive.model.FixedModeScheduleActionStartSettings.ReadOnly
    ] = scala
      .Option(impl.fixedModeScheduleActionStartSettings())
      .map(value =>
        zio.aws.medialive.model.FixedModeScheduleActionStartSettings.wrap(value)
      )
    override val followModeScheduleActionStartSettings: Option[
      zio.aws.medialive.model.FollowModeScheduleActionStartSettings.ReadOnly
    ] = scala
      .Option(impl.followModeScheduleActionStartSettings())
      .map(value =>
        zio.aws.medialive.model.FollowModeScheduleActionStartSettings
          .wrap(value)
      )
    override val immediateModeScheduleActionStartSettings: Option[
      zio.aws.medialive.model.ImmediateModeScheduleActionStartSettings.ReadOnly
    ] = scala
      .Option(impl.immediateModeScheduleActionStartSettings())
      .map(value =>
        zio.aws.medialive.model.ImmediateModeScheduleActionStartSettings
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.ScheduleActionStartSettings
  ): zio.aws.medialive.model.ScheduleActionStartSettings.ReadOnly = new Wrapper(
    impl
  )
}
