package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__integerMin1Max4
import scala.jdk.CollectionConverters._
final case class Scte20SourceSettings(
    convert608To708: Option[zio.aws.medialive.model.Scte20Convert608To708] =
      None,
    source608ChannelNumber: Option[__integerMin1Max4] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.Scte20SourceSettings = {
    import Scte20SourceSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.Scte20SourceSettings
      .builder()
      .optionallyWith(convert608To708.map(value => value.unwrap))(
        _.convert608To708
      )
      .optionallyWith(source608ChannelNumber.map(value => value: Integer))(
        _.source608ChannelNumber
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.Scte20SourceSettings.ReadOnly =
    zio.aws.medialive.model.Scte20SourceSettings.wrap(buildAwsValue())
}
object Scte20SourceSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.Scte20SourceSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.Scte20SourceSettings =
      zio.aws.medialive.model.Scte20SourceSettings(
        convert608To708.map(value => value),
        source608ChannelNumber.map(value => value)
      )
    def convert608To708: Option[zio.aws.medialive.model.Scte20Convert608To708]
    def source608ChannelNumber: Option[__integerMin1Max4]
    def getConvert608To708
        : ZIO[Any, AwsError, zio.aws.medialive.model.Scte20Convert608To708] =
      AwsError.unwrapOptionField("convert608To708", convert608To708)
    def getSource608ChannelNumber: ZIO[Any, AwsError, __integerMin1Max4] =
      AwsError.unwrapOptionField(
        "source608ChannelNumber",
        source608ChannelNumber
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.Scte20SourceSettings
  ) extends zio.aws.medialive.model.Scte20SourceSettings.ReadOnly {
    override val convert608To708
        : Option[zio.aws.medialive.model.Scte20Convert608To708] = scala
      .Option(impl.convert608To708())
      .map(value => zio.aws.medialive.model.Scte20Convert608To708.wrap(value))
    override val source608ChannelNumber: Option[__integerMin1Max4] = scala
      .Option(impl.source608ChannelNumber())
      .map(value => value: __integerMin1Max4)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.Scte20SourceSettings
  ): zio.aws.medialive.model.Scte20SourceSettings.ReadOnly = new Wrapper(impl)
}
