package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__integerMin1
import scala.jdk.CollectionConverters._
final case class Scte27SourceSettings(
    ocrLanguage: Option[zio.aws.medialive.model.Scte27OcrLanguage] = None,
    pid: Option[__integerMin1] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.Scte27SourceSettings = {
    import Scte27SourceSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.Scte27SourceSettings
      .builder()
      .optionallyWith(ocrLanguage.map(value => value.unwrap))(_.ocrLanguage)
      .optionallyWith(pid.map(value => value: Integer))(_.pid)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.Scte27SourceSettings.ReadOnly =
    zio.aws.medialive.model.Scte27SourceSettings.wrap(buildAwsValue())
}
object Scte27SourceSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.Scte27SourceSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.Scte27SourceSettings =
      zio.aws.medialive.model.Scte27SourceSettings(
        ocrLanguage.map(value => value),
        pid.map(value => value)
      )
    def ocrLanguage: Option[zio.aws.medialive.model.Scte27OcrLanguage]
    def pid: Option[__integerMin1]
    def getOcrLanguage
        : ZIO[Any, AwsError, zio.aws.medialive.model.Scte27OcrLanguage] =
      AwsError.unwrapOptionField("ocrLanguage", ocrLanguage)
    def getPid: ZIO[Any, AwsError, __integerMin1] =
      AwsError.unwrapOptionField("pid", pid)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.Scte27SourceSettings
  ) extends zio.aws.medialive.model.Scte27SourceSettings.ReadOnly {
    override val ocrLanguage
        : Option[zio.aws.medialive.model.Scte27OcrLanguage] = scala
      .Option(impl.ocrLanguage())
      .map(value => zio.aws.medialive.model.Scte27OcrLanguage.wrap(value))
    override val pid: Option[__integerMin1] =
      scala.Option(impl.pid()).map(value => value: __integerMin1)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.Scte27SourceSettings
  ): zio.aws.medialive.model.Scte27SourceSettings.ReadOnly = new Wrapper(impl)
}
