package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Scte35DeliveryRestrictions(
    archiveAllowedFlag: zio.aws.medialive.model.Scte35ArchiveAllowedFlag,
    deviceRestrictions: zio.aws.medialive.model.Scte35DeviceRestrictions,
    noRegionalBlackoutFlag: zio.aws.medialive.model.Scte35NoRegionalBlackoutFlag,
    webDeliveryAllowedFlag: zio.aws.medialive.model.Scte35WebDeliveryAllowedFlag
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.Scte35DeliveryRestrictions = {
    import Scte35DeliveryRestrictions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.Scte35DeliveryRestrictions
      .builder()
      .archiveAllowedFlag(archiveAllowedFlag.unwrap)
      .deviceRestrictions(deviceRestrictions.unwrap)
      .noRegionalBlackoutFlag(noRegionalBlackoutFlag.unwrap)
      .webDeliveryAllowedFlag(webDeliveryAllowedFlag.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.Scte35DeliveryRestrictions.ReadOnly =
    zio.aws.medialive.model.Scte35DeliveryRestrictions.wrap(buildAwsValue())
}
object Scte35DeliveryRestrictions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.Scte35DeliveryRestrictions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.Scte35DeliveryRestrictions =
      zio.aws.medialive.model.Scte35DeliveryRestrictions(
        archiveAllowedFlag,
        deviceRestrictions,
        noRegionalBlackoutFlag,
        webDeliveryAllowedFlag
      )
    def archiveAllowedFlag: zio.aws.medialive.model.Scte35ArchiveAllowedFlag
    def deviceRestrictions: zio.aws.medialive.model.Scte35DeviceRestrictions
    def noRegionalBlackoutFlag
        : zio.aws.medialive.model.Scte35NoRegionalBlackoutFlag
    def webDeliveryAllowedFlag
        : zio.aws.medialive.model.Scte35WebDeliveryAllowedFlag
    def getArchiveAllowedFlag
        : ZIO[Any, Nothing, zio.aws.medialive.model.Scte35ArchiveAllowedFlag] =
      ZIO.succeed(archiveAllowedFlag)
    def getDeviceRestrictions
        : ZIO[Any, Nothing, zio.aws.medialive.model.Scte35DeviceRestrictions] =
      ZIO.succeed(deviceRestrictions)
    def getNoRegionalBlackoutFlag: ZIO[
      Any,
      Nothing,
      zio.aws.medialive.model.Scte35NoRegionalBlackoutFlag
    ] = ZIO.succeed(noRegionalBlackoutFlag)
    def getWebDeliveryAllowedFlag: ZIO[
      Any,
      Nothing,
      zio.aws.medialive.model.Scte35WebDeliveryAllowedFlag
    ] = ZIO.succeed(webDeliveryAllowedFlag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.Scte35DeliveryRestrictions
  ) extends zio.aws.medialive.model.Scte35DeliveryRestrictions.ReadOnly {
    override val archiveAllowedFlag
        : zio.aws.medialive.model.Scte35ArchiveAllowedFlag =
      zio.aws.medialive.model.Scte35ArchiveAllowedFlag
        .wrap(impl.archiveAllowedFlag())
    override val deviceRestrictions
        : zio.aws.medialive.model.Scte35DeviceRestrictions =
      zio.aws.medialive.model.Scte35DeviceRestrictions
        .wrap(impl.deviceRestrictions())
    override val noRegionalBlackoutFlag
        : zio.aws.medialive.model.Scte35NoRegionalBlackoutFlag =
      zio.aws.medialive.model.Scte35NoRegionalBlackoutFlag
        .wrap(impl.noRegionalBlackoutFlag())
    override val webDeliveryAllowedFlag
        : zio.aws.medialive.model.Scte35WebDeliveryAllowedFlag =
      zio.aws.medialive.model.Scte35WebDeliveryAllowedFlag
        .wrap(impl.webDeliveryAllowedFlag())
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.Scte35DeliveryRestrictions
  ): zio.aws.medialive.model.Scte35DeliveryRestrictions.ReadOnly = new Wrapper(
    impl
  )
}
