package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{
  __string,
  __longMin0Max4294967295,
  __longMin0Max1099511627775,
  __integerMin0Max255
}
import scala.jdk.CollectionConverters._
final case class Scte35SegmentationDescriptor(
    deliveryRestrictions: Option[
      zio.aws.medialive.model.Scte35DeliveryRestrictions
    ] = None,
    segmentNum: Option[__integerMin0Max255] = None,
    segmentationCancelIndicator: zio.aws.medialive.model.Scte35SegmentationCancelIndicator,
    segmentationDuration: Option[__longMin0Max1099511627775] = None,
    segmentationEventId: __longMin0Max4294967295,
    segmentationTypeId: Option[__integerMin0Max255] = None,
    segmentationUpid: Option[__string] = None,
    segmentationUpidType: Option[__integerMin0Max255] = None,
    segmentsExpected: Option[__integerMin0Max255] = None,
    subSegmentNum: Option[__integerMin0Max255] = None,
    subSegmentsExpected: Option[__integerMin0Max255] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.Scte35SegmentationDescriptor = {
    import Scte35SegmentationDescriptor.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.Scte35SegmentationDescriptor
      .builder()
      .optionallyWith(deliveryRestrictions.map(value => value.buildAwsValue()))(
        _.deliveryRestrictions
      )
      .optionallyWith(segmentNum.map(value => value: Integer))(_.segmentNum)
      .segmentationCancelIndicator(segmentationCancelIndicator.unwrap)
      .optionallyWith(segmentationDuration.map(value => value: java.lang.Long))(
        _.segmentationDuration
      )
      .segmentationEventId(segmentationEventId: java.lang.Long)
      .optionallyWith(segmentationTypeId.map(value => value: Integer))(
        _.segmentationTypeId
      )
      .optionallyWith(segmentationUpid.map(value => value: java.lang.String))(
        _.segmentationUpid
      )
      .optionallyWith(segmentationUpidType.map(value => value: Integer))(
        _.segmentationUpidType
      )
      .optionallyWith(segmentsExpected.map(value => value: Integer))(
        _.segmentsExpected
      )
      .optionallyWith(subSegmentNum.map(value => value: Integer))(
        _.subSegmentNum
      )
      .optionallyWith(subSegmentsExpected.map(value => value: Integer))(
        _.subSegmentsExpected
      )
      .build()
  }
  def asReadOnly
      : zio.aws.medialive.model.Scte35SegmentationDescriptor.ReadOnly =
    zio.aws.medialive.model.Scte35SegmentationDescriptor.wrap(buildAwsValue())
}
object Scte35SegmentationDescriptor {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.Scte35SegmentationDescriptor
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.Scte35SegmentationDescriptor =
      zio.aws.medialive.model.Scte35SegmentationDescriptor(
        deliveryRestrictions.map(value => value.asEditable),
        segmentNum.map(value => value),
        segmentationCancelIndicator,
        segmentationDuration.map(value => value),
        segmentationEventId,
        segmentationTypeId.map(value => value),
        segmentationUpid.map(value => value),
        segmentationUpidType.map(value => value),
        segmentsExpected.map(value => value),
        subSegmentNum.map(value => value),
        subSegmentsExpected.map(value => value)
      )
    def deliveryRestrictions
        : Option[zio.aws.medialive.model.Scte35DeliveryRestrictions.ReadOnly]
    def segmentNum: Option[__integerMin0Max255]
    def segmentationCancelIndicator
        : zio.aws.medialive.model.Scte35SegmentationCancelIndicator
    def segmentationDuration: Option[__longMin0Max1099511627775]
    def segmentationEventId: __longMin0Max4294967295
    def segmentationTypeId: Option[__integerMin0Max255]
    def segmentationUpid: Option[__string]
    def segmentationUpidType: Option[__integerMin0Max255]
    def segmentsExpected: Option[__integerMin0Max255]
    def subSegmentNum: Option[__integerMin0Max255]
    def subSegmentsExpected: Option[__integerMin0Max255]
    def getDeliveryRestrictions: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.Scte35DeliveryRestrictions.ReadOnly
    ] = AwsError.unwrapOptionField("deliveryRestrictions", deliveryRestrictions)
    def getSegmentNum: ZIO[Any, AwsError, __integerMin0Max255] =
      AwsError.unwrapOptionField("segmentNum", segmentNum)
    def getSegmentationCancelIndicator: ZIO[
      Any,
      Nothing,
      zio.aws.medialive.model.Scte35SegmentationCancelIndicator
    ] = ZIO.succeed(segmentationCancelIndicator)
    def getSegmentationDuration
        : ZIO[Any, AwsError, __longMin0Max1099511627775] =
      AwsError.unwrapOptionField("segmentationDuration", segmentationDuration)
    def getSegmentationEventId: ZIO[Any, Nothing, __longMin0Max4294967295] =
      ZIO.succeed(segmentationEventId)
    def getSegmentationTypeId: ZIO[Any, AwsError, __integerMin0Max255] =
      AwsError.unwrapOptionField("segmentationTypeId", segmentationTypeId)
    def getSegmentationUpid: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("segmentationUpid", segmentationUpid)
    def getSegmentationUpidType: ZIO[Any, AwsError, __integerMin0Max255] =
      AwsError.unwrapOptionField("segmentationUpidType", segmentationUpidType)
    def getSegmentsExpected: ZIO[Any, AwsError, __integerMin0Max255] =
      AwsError.unwrapOptionField("segmentsExpected", segmentsExpected)
    def getSubSegmentNum: ZIO[Any, AwsError, __integerMin0Max255] =
      AwsError.unwrapOptionField("subSegmentNum", subSegmentNum)
    def getSubSegmentsExpected: ZIO[Any, AwsError, __integerMin0Max255] =
      AwsError.unwrapOptionField("subSegmentsExpected", subSegmentsExpected)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.Scte35SegmentationDescriptor
  ) extends zio.aws.medialive.model.Scte35SegmentationDescriptor.ReadOnly {
    override val deliveryRestrictions
        : Option[zio.aws.medialive.model.Scte35DeliveryRestrictions.ReadOnly] =
      scala
        .Option(impl.deliveryRestrictions())
        .map(value =>
          zio.aws.medialive.model.Scte35DeliveryRestrictions.wrap(value)
        )
    override val segmentNum: Option[__integerMin0Max255] =
      scala.Option(impl.segmentNum()).map(value => value: __integerMin0Max255)
    override val segmentationCancelIndicator
        : zio.aws.medialive.model.Scte35SegmentationCancelIndicator =
      zio.aws.medialive.model.Scte35SegmentationCancelIndicator
        .wrap(impl.segmentationCancelIndicator())
    override val segmentationDuration: Option[__longMin0Max1099511627775] =
      scala
        .Option(impl.segmentationDuration())
        .map(value => value: __longMin0Max1099511627775)
    override val segmentationEventId: __longMin0Max4294967295 =
      impl.segmentationEventId(): __longMin0Max4294967295
    override val segmentationTypeId: Option[__integerMin0Max255] = scala
      .Option(impl.segmentationTypeId())
      .map(value => value: __integerMin0Max255)
    override val segmentationUpid: Option[__string] =
      scala.Option(impl.segmentationUpid()).map(value => value: __string)
    override val segmentationUpidType: Option[__integerMin0Max255] = scala
      .Option(impl.segmentationUpidType())
      .map(value => value: __integerMin0Max255)
    override val segmentsExpected: Option[__integerMin0Max255] = scala
      .Option(impl.segmentsExpected())
      .map(value => value: __integerMin0Max255)
    override val subSegmentNum: Option[__integerMin0Max255] = scala
      .Option(impl.subSegmentNum())
      .map(value => value: __integerMin0Max255)
    override val subSegmentsExpected: Option[__integerMin0Max255] = scala
      .Option(impl.subSegmentsExpected())
      .map(value => value: __integerMin0Max255)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.Scte35SegmentationDescriptor
  ): zio.aws.medialive.model.Scte35SegmentationDescriptor.ReadOnly =
    new Wrapper(impl)
}
