package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__integerMinNegative1000Max1000
import scala.jdk.CollectionConverters._
final case class Scte35TimeSignalApos(
    adAvailOffset: Option[__integerMinNegative1000Max1000] = None,
    noRegionalBlackoutFlag: Option[
      zio.aws.medialive.model.Scte35AposNoRegionalBlackoutBehavior
    ] = None,
    webDeliveryAllowedFlag: Option[
      zio.aws.medialive.model.Scte35AposWebDeliveryAllowedBehavior
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.Scte35TimeSignalApos = {
    import Scte35TimeSignalApos.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.Scte35TimeSignalApos
      .builder()
      .optionallyWith(adAvailOffset.map(value => value: Integer))(
        _.adAvailOffset
      )
      .optionallyWith(noRegionalBlackoutFlag.map(value => value.unwrap))(
        _.noRegionalBlackoutFlag
      )
      .optionallyWith(webDeliveryAllowedFlag.map(value => value.unwrap))(
        _.webDeliveryAllowedFlag
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.Scte35TimeSignalApos.ReadOnly =
    zio.aws.medialive.model.Scte35TimeSignalApos.wrap(buildAwsValue())
}
object Scte35TimeSignalApos {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.Scte35TimeSignalApos
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.Scte35TimeSignalApos =
      zio.aws.medialive.model.Scte35TimeSignalApos(
        adAvailOffset.map(value => value),
        noRegionalBlackoutFlag.map(value => value),
        webDeliveryAllowedFlag.map(value => value)
      )
    def adAvailOffset: Option[__integerMinNegative1000Max1000]
    def noRegionalBlackoutFlag
        : Option[zio.aws.medialive.model.Scte35AposNoRegionalBlackoutBehavior]
    def webDeliveryAllowedFlag
        : Option[zio.aws.medialive.model.Scte35AposWebDeliveryAllowedBehavior]
    def getAdAvailOffset: ZIO[Any, AwsError, __integerMinNegative1000Max1000] =
      AwsError.unwrapOptionField("adAvailOffset", adAvailOffset)
    def getNoRegionalBlackoutFlag: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.Scte35AposNoRegionalBlackoutBehavior
    ] = AwsError.unwrapOptionField(
      "noRegionalBlackoutFlag",
      noRegionalBlackoutFlag
    )
    def getWebDeliveryAllowedFlag: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.Scte35AposWebDeliveryAllowedBehavior
    ] = AwsError.unwrapOptionField(
      "webDeliveryAllowedFlag",
      webDeliveryAllowedFlag
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.Scte35TimeSignalApos
  ) extends zio.aws.medialive.model.Scte35TimeSignalApos.ReadOnly {
    override val adAvailOffset: Option[__integerMinNegative1000Max1000] = scala
      .Option(impl.adAvailOffset())
      .map(value => value: __integerMinNegative1000Max1000)
    override val noRegionalBlackoutFlag
        : Option[zio.aws.medialive.model.Scte35AposNoRegionalBlackoutBehavior] =
      scala
        .Option(impl.noRegionalBlackoutFlag())
        .map(value =>
          zio.aws.medialive.model.Scte35AposNoRegionalBlackoutBehavior
            .wrap(value)
        )
    override val webDeliveryAllowedFlag
        : Option[zio.aws.medialive.model.Scte35AposWebDeliveryAllowedBehavior] =
      scala
        .Option(impl.webDeliveryAllowedFlag())
        .map(value =>
          zio.aws.medialive.model.Scte35AposWebDeliveryAllowedBehavior
            .wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.Scte35TimeSignalApos
  ): zio.aws.medialive.model.Scte35TimeSignalApos.ReadOnly = new Wrapper(impl)
}
