package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Scte35TimeSignalScheduleActionSettings(
    scte35Descriptors: Iterable[zio.aws.medialive.model.Scte35Descriptor]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.Scte35TimeSignalScheduleActionSettings = {
    import Scte35TimeSignalScheduleActionSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.Scte35TimeSignalScheduleActionSettings
      .builder()
      .scte35Descriptors(scte35Descriptors.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.medialive.model.Scte35TimeSignalScheduleActionSettings.ReadOnly =
    zio.aws.medialive.model.Scte35TimeSignalScheduleActionSettings
      .wrap(buildAwsValue())
}
object Scte35TimeSignalScheduleActionSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.Scte35TimeSignalScheduleActionSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.medialive.model.Scte35TimeSignalScheduleActionSettings =
      zio.aws.medialive.model
        .Scte35TimeSignalScheduleActionSettings(scte35Descriptors.map { item =>
          item.asEditable
        })
    def scte35Descriptors
        : List[zio.aws.medialive.model.Scte35Descriptor.ReadOnly]
    def getScte35Descriptors: ZIO[Any, Nothing, List[
      zio.aws.medialive.model.Scte35Descriptor.ReadOnly
    ]] = ZIO.succeed(scte35Descriptors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.Scte35TimeSignalScheduleActionSettings
  ) extends zio.aws.medialive.model.Scte35TimeSignalScheduleActionSettings.ReadOnly {
    override val scte35Descriptors
        : List[zio.aws.medialive.model.Scte35Descriptor.ReadOnly] = impl
      .scte35Descriptors()
      .asScala
      .map { item =>
        zio.aws.medialive.model.Scte35Descriptor.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.Scte35TimeSignalScheduleActionSettings
  ): zio.aws.medialive.model.Scte35TimeSignalScheduleActionSettings.ReadOnly =
    new Wrapper(impl)
}
