package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait Scte35WebDeliveryAllowedFlag {
  def unwrap: software.amazon.awssdk.services.medialive.model.Scte35WebDeliveryAllowedFlag
}
object Scte35WebDeliveryAllowedFlag {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.Scte35WebDeliveryAllowedFlag
  ): zio.aws.medialive.model.Scte35WebDeliveryAllowedFlag = value match {
    case software.amazon.awssdk.services.medialive.model.Scte35WebDeliveryAllowedFlag.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.Scte35WebDeliveryAllowedFlag.WEB_DELIVERY_NOT_ALLOWED =>
      val r = WEB_DELIVERY_NOT_ALLOWED
      r
    case software.amazon.awssdk.services.medialive.model.Scte35WebDeliveryAllowedFlag.WEB_DELIVERY_ALLOWED =>
      val r = WEB_DELIVERY_ALLOWED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.Scte35WebDeliveryAllowedFlag {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Scte35WebDeliveryAllowedFlag =
      software.amazon.awssdk.services.medialive.model.Scte35WebDeliveryAllowedFlag.UNKNOWN_TO_SDK_VERSION
  }
  case object WEB_DELIVERY_NOT_ALLOWED
      extends zio.aws.medialive.model.Scte35WebDeliveryAllowedFlag {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Scte35WebDeliveryAllowedFlag =
      software.amazon.awssdk.services.medialive.model.Scte35WebDeliveryAllowedFlag.WEB_DELIVERY_NOT_ALLOWED
  }
  case object WEB_DELIVERY_ALLOWED
      extends zio.aws.medialive.model.Scte35WebDeliveryAllowedFlag {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Scte35WebDeliveryAllowedFlag =
      software.amazon.awssdk.services.medialive.model.Scte35WebDeliveryAllowedFlag.WEB_DELIVERY_ALLOWED
  }
}
