package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait SmoothGroupSegmentationMode {
  def unwrap: software.amazon.awssdk.services.medialive.model.SmoothGroupSegmentationMode
}
object SmoothGroupSegmentationMode {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.SmoothGroupSegmentationMode
  ): zio.aws.medialive.model.SmoothGroupSegmentationMode = value match {
    case software.amazon.awssdk.services.medialive.model.SmoothGroupSegmentationMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.SmoothGroupSegmentationMode.USE_INPUT_SEGMENTATION =>
      val r = USE_INPUT_SEGMENTATION
      r
    case software.amazon.awssdk.services.medialive.model.SmoothGroupSegmentationMode.USE_SEGMENT_DURATION =>
      val r = USE_SEGMENT_DURATION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.SmoothGroupSegmentationMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.SmoothGroupSegmentationMode =
      software.amazon.awssdk.services.medialive.model.SmoothGroupSegmentationMode.UNKNOWN_TO_SDK_VERSION
  }
  case object USE_INPUT_SEGMENTATION
      extends zio.aws.medialive.model.SmoothGroupSegmentationMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.SmoothGroupSegmentationMode =
      software.amazon.awssdk.services.medialive.model.SmoothGroupSegmentationMode.USE_INPUT_SEGMENTATION
  }
  case object USE_SEGMENT_DURATION
      extends zio.aws.medialive.model.SmoothGroupSegmentationMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.SmoothGroupSegmentationMode =
      software.amazon.awssdk.services.medialive.model.SmoothGroupSegmentationMode.USE_SEGMENT_DURATION
  }
}
