package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait SmoothGroupSparseTrackType {
  def unwrap: software.amazon.awssdk.services.medialive.model.SmoothGroupSparseTrackType
}
object SmoothGroupSparseTrackType {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.SmoothGroupSparseTrackType
  ): zio.aws.medialive.model.SmoothGroupSparseTrackType = value match {
    case software.amazon.awssdk.services.medialive.model.SmoothGroupSparseTrackType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.SmoothGroupSparseTrackType.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.medialive.model.SmoothGroupSparseTrackType.SCTE_35 =>
      val r = SCTE_35
      r
    case software.amazon.awssdk.services.medialive.model.SmoothGroupSparseTrackType.SCTE_35_WITHOUT_SEGMENTATION =>
      val r = SCTE_35_WITHOUT_SEGMENTATION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.SmoothGroupSparseTrackType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.SmoothGroupSparseTrackType =
      software.amazon.awssdk.services.medialive.model.SmoothGroupSparseTrackType.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.medialive.model.SmoothGroupSparseTrackType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.SmoothGroupSparseTrackType =
      software.amazon.awssdk.services.medialive.model.SmoothGroupSparseTrackType.NONE
  }
  case object SCTE_35
      extends zio.aws.medialive.model.SmoothGroupSparseTrackType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.SmoothGroupSparseTrackType =
      software.amazon.awssdk.services.medialive.model.SmoothGroupSparseTrackType.SCTE_35
  }
  case object SCTE_35_WITHOUT_SEGMENTATION
      extends zio.aws.medialive.model.SmoothGroupSparseTrackType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.SmoothGroupSparseTrackType =
      software.amazon.awssdk.services.medialive.model.SmoothGroupSparseTrackType.SCTE_35_WITHOUT_SEGMENTATION
  }
}
