package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class StandardHlsSettings(
    audioRenditionSets: Option[__string] = None,
    m3u8Settings: zio.aws.medialive.model.M3u8Settings
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.StandardHlsSettings = {
    import StandardHlsSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.StandardHlsSettings
      .builder()
      .optionallyWith(audioRenditionSets.map(value => value: java.lang.String))(
        _.audioRenditionSets
      )
      .m3u8Settings(m3u8Settings.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.StandardHlsSettings.ReadOnly =
    zio.aws.medialive.model.StandardHlsSettings.wrap(buildAwsValue())
}
object StandardHlsSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.StandardHlsSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.StandardHlsSettings =
      zio.aws.medialive.model.StandardHlsSettings(
        audioRenditionSets.map(value => value),
        m3u8Settings.asEditable
      )
    def audioRenditionSets: Option[__string]
    def m3u8Settings: zio.aws.medialive.model.M3u8Settings.ReadOnly
    def getAudioRenditionSets: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("audioRenditionSets", audioRenditionSets)
    def getM3u8Settings
        : ZIO[Any, Nothing, zio.aws.medialive.model.M3u8Settings.ReadOnly] =
      ZIO.succeed(m3u8Settings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.StandardHlsSettings
  ) extends zio.aws.medialive.model.StandardHlsSettings.ReadOnly {
    override val audioRenditionSets: Option[__string] =
      scala.Option(impl.audioRenditionSets()).map(value => value: __string)
    override val m3u8Settings: zio.aws.medialive.model.M3u8Settings.ReadOnly =
      zio.aws.medialive.model.M3u8Settings.wrap(impl.m3u8Settings())
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.StandardHlsSettings
  ): zio.aws.medialive.model.StandardHlsSettings.ReadOnly = new Wrapper(impl)
}
